package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseLogStreamsResponse(logStreams: scala.Option[Iterable[String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse = {
    import GetRelationalDatabaseLogStreamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse.builder().optionallyWith(logStreams.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.logStreams).build()
  }
  def asReadOnly: GetRelationalDatabaseLogStreamsResponse.ReadOnly = GetRelationalDatabaseLogStreamsResponse.wrap(buildAwsValue())
}
object GetRelationalDatabaseLogStreamsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseLogStreamsResponse = GetRelationalDatabaseLogStreamsResponse(logStreamsValue.map(value => value))
    def logStreamsValue: scala.Option[List[String]]
    def logStreams: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("logStreams", logStreamsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse) extends GetRelationalDatabaseLogStreamsResponse.ReadOnly {
    override def logStreamsValue: scala.Option[List[String]] = scala.Option(impl.logStreams()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse): ReadOnly = new Wrapper(impl)
}