package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetLoadBalancerRequest(loadBalancerName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest = {
    import GetLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest.builder().loadBalancerName(loadBalancerName: java.lang.String).build()
  }
  def asReadOnly: GetLoadBalancerRequest.ReadOnly = GetLoadBalancerRequest.wrap(buildAwsValue())
}
object GetLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetLoadBalancerRequest = GetLoadBalancerRequest(loadBalancerNameValue)
    def loadBalancerNameValue: primitives.ResourceName
    def loadBalancerName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(loadBalancerNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest) extends GetLoadBalancerRequest.ReadOnly { override def loadBalancerNameValue: primitives.ResourceName = impl.loadBalancerName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest): ReadOnly = new Wrapper(impl)
}