package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetInstanceMetricDataRequest(instanceName: primitives.ResourceName, metricName: InstanceMetricName, period: primitives.MetricPeriod, startTime: primitives.Timestamp, endTime: primitives.Timestamp, unit: MetricUnit, statistics: Iterable[MetricStatistic]) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest = {
    import GetInstanceMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest.builder().instanceName(instanceName: java.lang.String).metricName(metricName.unwrap).period(period: java.lang.Integer).startTime(startTime: java.time.Instant).endTime(endTime: java.time.Instant).unit(unit.unwrap).statisticsWithStrings(statistics.map { item => 
      item.unwrap.toString
    }.asJavaCollection).build()
  }
  def asReadOnly: GetInstanceMetricDataRequest.ReadOnly = GetInstanceMetricDataRequest.wrap(buildAwsValue())
}
object GetInstanceMetricDataRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetInstanceMetricDataRequest = GetInstanceMetricDataRequest(instanceNameValue, metricNameValue, periodValue, startTimeValue, endTimeValue, unitValue, statisticsValue)
    def instanceNameValue: primitives.ResourceName
    def metricNameValue: InstanceMetricName
    def periodValue: primitives.MetricPeriod
    def startTimeValue: primitives.Timestamp
    def endTimeValue: primitives.Timestamp
    def unitValue: MetricUnit
    def statisticsValue: List[MetricStatistic]
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
    def metricName: ZIO[Any, Nothing, InstanceMetricName] = ZIO.succeed(metricNameValue)
    def period: ZIO[Any, Nothing, primitives.MetricPeriod] = ZIO.succeed(periodValue)
    def startTime: ZIO[Any, Nothing, primitives.Timestamp] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, primitives.Timestamp] = ZIO.succeed(endTimeValue)
    def unit: ZIO[Any, Nothing, MetricUnit] = ZIO.succeed(unitValue)
    def statistics: ZIO[Any, Nothing, List[MetricStatistic]] = ZIO.succeed(statisticsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest) extends GetInstanceMetricDataRequest.ReadOnly {
    override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName
    override def metricNameValue: InstanceMetricName = InstanceMetricName.wrap(impl.metricName())
    override def periodValue: primitives.MetricPeriod = impl.period(): primitives.MetricPeriod
    override def startTimeValue: primitives.Timestamp = impl.startTime(): primitives.Timestamp
    override def endTimeValue: primitives.Timestamp = impl.endTime(): primitives.Timestamp
    override def unitValue: MetricUnit = MetricUnit.wrap(impl.unit())
    override def statisticsValue: List[MetricStatistic] = impl.statistics().asScala.map { item => 
      MetricStatistic.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest): ReadOnly = new Wrapper(impl)
}