package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDomainsResponse(domains: scala.Option[Iterable[Domain]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDomainsResponse = {
    import GetDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDomainsResponse.builder().optionallyWith(domains.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.domains).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetDomainsResponse.ReadOnly = GetDomainsResponse.wrap(buildAwsValue())
}
object GetDomainsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDomainsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDomainsResponse = GetDomainsResponse(domainsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def domainsValue: scala.Option[List[Domain.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def domains: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Domain.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domains", domainsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDomainsResponse) extends GetDomainsResponse.ReadOnly {
    override def domainsValue: scala.Option[List[Domain.ReadOnly]] = scala.Option(impl.domains()).map(value => value.asScala.map { item => 
      Domain.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDomainsResponse): ReadOnly = new Wrapper(impl)
}