package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetContainerApiMetadataResponse(metadata: scala.Option[Iterable[Map[String, String]]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse = {
    import GetContainerApiMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse.builder().optionallyWith(metadata.map(value => value.map { item => 
      item.map({
        case (key, value) =>
          (key: java.lang.String) -> (value: java.lang.String)
      }).asJava
    }.asJavaCollection))(_.metadata).build()
  }
  def asReadOnly: GetContainerApiMetadataResponse.ReadOnly = GetContainerApiMetadataResponse.wrap(buildAwsValue())
}
object GetContainerApiMetadataResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetContainerApiMetadataResponse = GetContainerApiMetadataResponse(metadataValue.map(value => value))
    def metadataValue: scala.Option[List[Map[String, String]]]
    def metadata: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Map[String, String]]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("metadata", metadataValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse) extends GetContainerApiMetadataResponse.ReadOnly {
    override def metadataValue: scala.Option[List[Map[String, String]]] = scala.Option(impl.metadata()).map(value => value.asScala.map { item => 
      item.asScala.map({
        case (key, value) =>
          (key: String) -> (value: String)
      }).toMap
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse): ReadOnly = new Wrapper(impl)
}