package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DiskInfo(name: scala.Option[String] = None, path: scala.Option[primitives.NonEmptyString] = None, sizeInGb: scala.Option[primitives.Integer] = None, isSystemDisk: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DiskInfo = {
    import DiskInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DiskInfo.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(path.map(value => value: java.lang.String))(_.path).optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(_.sizeInGb).optionallyWith(isSystemDisk.map(value => value: java.lang.Boolean))(_.isSystemDisk).build()
  }
  def asReadOnly: DiskInfo.ReadOnly = DiskInfo.wrap(buildAwsValue())
}
object DiskInfo {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DiskInfo] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DiskInfo = DiskInfo(nameValue.map(value => value), pathValue.map(value => value), sizeInGbValue.map(value => value), isSystemDiskValue.map(value => value))
    def nameValue: scala.Option[String]
    def pathValue: scala.Option[primitives.NonEmptyString]
    def sizeInGbValue: scala.Option[primitives.Integer]
    def isSystemDiskValue: scala.Option[Boolean]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def path: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("path", pathValue)
    def sizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sizeInGb", sizeInGbValue)
    def isSystemDisk: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isSystemDisk", isSystemDiskValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DiskInfo) extends DiskInfo.ReadOnly {
    override def nameValue: scala.Option[String] = scala.Option(impl.name()).map(value => value: String)
    override def pathValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.path()).map(value => value: primitives.NonEmptyString)
    override def sizeInGbValue: scala.Option[primitives.Integer] = scala.Option(impl.sizeInGb()).map(value => value: primitives.Integer)
    override def isSystemDiskValue: scala.Option[Boolean] = scala.Option(impl.isSystemDisk()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DiskInfo): ReadOnly = new Wrapper(impl)
}