package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteAlarmRequest(alarmName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest = {
    import DeleteAlarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest.builder().alarmName(alarmName: java.lang.String).build()
  }
  def asReadOnly: DeleteAlarmRequest.ReadOnly = DeleteAlarmRequest.wrap(buildAwsValue())
}
object DeleteAlarmRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteAlarmRequest = DeleteAlarmRequest(alarmNameValue)
    def alarmNameValue: primitives.ResourceName
    def alarmName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(alarmNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest) extends DeleteAlarmRequest.ReadOnly { override def alarmNameValue: primitives.ResourceName = impl.alarmName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest): ReadOnly = new Wrapper(impl)
}