package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateContainerServiceRequest(serviceName: primitives.ContainerServiceName, power: ContainerServicePowerName, scale: primitives.ContainerServiceScale, tags: scala.Option[Iterable[Tag]] = None, publicDomainNames: scala.Option[Map[String, Iterable[String]]] = None, deployment: scala.Option[ContainerServiceDeploymentRequest] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest = {
    import CreateContainerServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest.builder().serviceName(serviceName: java.lang.String).power(power.unwrap).scale(scale: java.lang.Integer).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(publicDomainNames.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> value.map { item => 
          item: java.lang.String
        }.asJavaCollection
    }).asJava))(_.publicDomainNames).optionallyWith(deployment.map(value => value.buildAwsValue()))(_.deployment).build()
  }
  def asReadOnly: CreateContainerServiceRequest.ReadOnly = CreateContainerServiceRequest.wrap(buildAwsValue())
}
object CreateContainerServiceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateContainerServiceRequest = CreateContainerServiceRequest(serviceNameValue, powerValue, scaleValue, tagsValue.map(value => value.map { item => 
      item.editable
    }), publicDomainNamesValue.map(value => value), deploymentValue.map(value => value.editable))
    def serviceNameValue: primitives.ContainerServiceName
    def powerValue: ContainerServicePowerName
    def scaleValue: primitives.ContainerServiceScale
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def publicDomainNamesValue: scala.Option[Map[String, List[String]]]
    def deploymentValue: scala.Option[ContainerServiceDeploymentRequest.ReadOnly]
    def serviceName: ZIO[Any, Nothing, primitives.ContainerServiceName] = ZIO.succeed(serviceNameValue)
    def power: ZIO[Any, Nothing, ContainerServicePowerName] = ZIO.succeed(powerValue)
    def scale: ZIO[Any, Nothing, primitives.ContainerServiceScale] = ZIO.succeed(scaleValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def publicDomainNames: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[String, List[String]]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publicDomainNames", publicDomainNamesValue)
    def deployment: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerServiceDeploymentRequest.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deployment", deploymentValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest) extends CreateContainerServiceRequest.ReadOnly {
    override def serviceNameValue: primitives.ContainerServiceName = impl.serviceName(): primitives.ContainerServiceName
    override def powerValue: ContainerServicePowerName = ContainerServicePowerName.wrap(impl.power())
    override def scaleValue: primitives.ContainerServiceScale = impl.scale(): primitives.ContainerServiceScale
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def publicDomainNamesValue: scala.Option[Map[String, List[String]]] = scala.Option(impl.publicDomainNames()).map(value => value.asScala.map({
      case (key, value) =>
        (key: String) -> value.asScala.map { item => 
          item: String
        }.toList
    }).toMap)
    override def deploymentValue: scala.Option[ContainerServiceDeploymentRequest.ReadOnly] = scala.Option(impl.deployment()).map(value => ContainerServiceDeploymentRequest.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest): ReadOnly = new Wrapper(impl)
}