package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateContainerServiceDeploymentResponse(containerService: scala.Option[ContainerService] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse = {
    import CreateContainerServiceDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse.builder().optionallyWith(containerService.map(value => value.buildAwsValue()))(_.containerService).build()
  }
  def asReadOnly: CreateContainerServiceDeploymentResponse.ReadOnly = CreateContainerServiceDeploymentResponse.wrap(buildAwsValue())
}
object CreateContainerServiceDeploymentResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateContainerServiceDeploymentResponse = CreateContainerServiceDeploymentResponse(containerServiceValue.map(value => value.editable))
    def containerServiceValue: scala.Option[ContainerService.ReadOnly]
    def containerService: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerService.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("containerService", containerServiceValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse) extends CreateContainerServiceDeploymentResponse.ReadOnly { override def containerServiceValue: scala.Option[ContainerService.ReadOnly] = scala.Option(impl.containerService()).map(value => ContainerService.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse): ReadOnly = new Wrapper(impl)
}