package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AddOnRequest(addOnType: AddOnType, autoSnapshotAddOnRequest: scala.Option[AutoSnapshotAddOnRequest] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AddOnRequest = {
    import AddOnRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AddOnRequest.builder().addOnType(addOnType.unwrap).optionallyWith(autoSnapshotAddOnRequest.map(value => value.buildAwsValue()))(_.autoSnapshotAddOnRequest).build()
  }
  def asReadOnly: AddOnRequest.ReadOnly = AddOnRequest.wrap(buildAwsValue())
}
object AddOnRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.AddOnRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AddOnRequest = AddOnRequest(addOnTypeValue, autoSnapshotAddOnRequestValue.map(value => value.editable))
    def addOnTypeValue: AddOnType
    def autoSnapshotAddOnRequestValue: scala.Option[AutoSnapshotAddOnRequest.ReadOnly]
    def addOnType: ZIO[Any, Nothing, AddOnType] = ZIO.succeed(addOnTypeValue)
    def autoSnapshotAddOnRequest: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AutoSnapshotAddOnRequest.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("autoSnapshotAddOnRequest", autoSnapshotAddOnRequestValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.AddOnRequest) extends AddOnRequest.ReadOnly {
    override def addOnTypeValue: AddOnType = AddOnType.wrap(impl.addOnType())
    override def autoSnapshotAddOnRequestValue: scala.Option[AutoSnapshotAddOnRequest.ReadOnly] = scala.Option(impl.autoSnapshotAddOnRequest()).map(value => AutoSnapshotAddOnRequest.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.AddOnRequest): ReadOnly = new Wrapper(impl)
}