package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ResetDistributionCacheResponse(status: scala.Option[String] = None, createTime: scala.Option[primitives.IsoDate] = None, operation: scala.Option[Operation] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse = {
    import ResetDistributionCacheResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse.builder().optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(createTime.map(value => value: java.time.Instant))(_.createTime).optionallyWith(operation.map(value => value.buildAwsValue()))(_.operation).build()
  }
  def asReadOnly: ResetDistributionCacheResponse.ReadOnly = ResetDistributionCacheResponse.wrap(buildAwsValue())
}
object ResetDistributionCacheResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ResetDistributionCacheResponse = ResetDistributionCacheResponse(statusValue.map(value => value), createTimeValue.map(value => value), operationValue.map(value => value.editable))
    def statusValue: scala.Option[String]
    def createTimeValue: scala.Option[primitives.IsoDate]
    def operationValue: scala.Option[Operation.ReadOnly]
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def createTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createTime", createTimeValue)
    def operation: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Operation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operation", operationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse) extends ResetDistributionCacheResponse.ReadOnly {
    override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
    override def createTimeValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createTime()).map(value => value: primitives.IsoDate)
    override def operationValue: scala.Option[Operation.ReadOnly] = scala.Option(impl.operation()).map(value => Operation.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse): ReadOnly = new Wrapper(impl)
}