package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetOperationsRequest(pageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetOperationsRequest = {
    import GetOperationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetOperationsRequest.builder().optionallyWith(pageToken.map(value => value: java.lang.String))(_.pageToken).build()
  }
  def asReadOnly: GetOperationsRequest.ReadOnly = GetOperationsRequest.wrap(buildAwsValue())
}
object GetOperationsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetOperationsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetOperationsRequest = GetOperationsRequest(pageTokenValue.map(value => value))
    def pageTokenValue: scala.Option[String]
    def pageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetOperationsRequest) extends GetOperationsRequest.ReadOnly { override def pageTokenValue: scala.Option[String] = scala.Option(impl.pageToken()).map(value => value: String) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetOperationsRequest): ReadOnly = new Wrapper(impl)
}