package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetInstancesResponse(instances: scala.Option[Iterable[Instance]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetInstancesResponse = {
    import GetInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstancesResponse.builder().optionallyWith(instances.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.instances).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetInstancesResponse.ReadOnly = GetInstancesResponse.wrap(buildAwsValue())
}
object GetInstancesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetInstancesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetInstancesResponse = GetInstancesResponse(instancesValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def instancesValue: scala.Option[List[Instance.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def instances: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Instance.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instances", instancesValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetInstancesResponse) extends GetInstancesResponse.ReadOnly {
    override def instancesValue: scala.Option[List[Instance.ReadOnly]] = scala.Option(impl.instances()).map(value => value.asScala.map { item => 
      Instance.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetInstancesResponse): ReadOnly = new Wrapper(impl)
}