package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetInstancePortStatesRequest(instanceName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest = {
    import GetInstancePortStatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest.builder().instanceName(instanceName: java.lang.String).build()
  }
  def asReadOnly: GetInstancePortStatesRequest.ReadOnly = GetInstancePortStatesRequest.wrap(buildAwsValue())
}
object GetInstancePortStatesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetInstancePortStatesRequest = GetInstancePortStatesRequest(instanceNameValue)
    def instanceNameValue: primitives.ResourceName
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest) extends GetInstancePortStatesRequest.ReadOnly { override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest): ReadOnly = new Wrapper(impl)
}