package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDomainsRequest(pageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDomainsRequest = {
    import GetDomainsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDomainsRequest.builder().optionallyWith(pageToken.map(value => value: java.lang.String))(_.pageToken).build()
  }
  def asReadOnly: GetDomainsRequest.ReadOnly = GetDomainsRequest.wrap(buildAwsValue())
}
object GetDomainsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDomainsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDomainsRequest = GetDomainsRequest(pageTokenValue.map(value => value))
    def pageTokenValue: scala.Option[String]
    def pageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDomainsRequest) extends GetDomainsRequest.ReadOnly { override def pageTokenValue: scala.Option[String] = scala.Option(impl.pageToken()).map(value => value: String) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDomainsRequest): ReadOnly = new Wrapper(impl)
}