package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDistributionMetricDataRequest(distributionName: primitives.ResourceName, metricName: DistributionMetricName, startTime: primitives.Timestamp, endTime: primitives.Timestamp, period: primitives.MetricPeriod, unit: MetricUnit, statistics: Iterable[MetricStatistic]) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest = {
    import GetDistributionMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest.builder().distributionName(distributionName: java.lang.String).metricName(metricName.unwrap).startTime(startTime: java.time.Instant).endTime(endTime: java.time.Instant).period(period: java.lang.Integer).unit(unit.unwrap).statisticsWithStrings(statistics.map { item => 
      item.unwrap.toString
    }.asJavaCollection).build()
  }
  def asReadOnly: GetDistributionMetricDataRequest.ReadOnly = GetDistributionMetricDataRequest.wrap(buildAwsValue())
}
object GetDistributionMetricDataRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDistributionMetricDataRequest = GetDistributionMetricDataRequest(distributionNameValue, metricNameValue, startTimeValue, endTimeValue, periodValue, unitValue, statisticsValue)
    def distributionNameValue: primitives.ResourceName
    def metricNameValue: DistributionMetricName
    def startTimeValue: primitives.Timestamp
    def endTimeValue: primitives.Timestamp
    def periodValue: primitives.MetricPeriod
    def unitValue: MetricUnit
    def statisticsValue: List[MetricStatistic]
    def distributionName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(distributionNameValue)
    def metricName: ZIO[Any, Nothing, DistributionMetricName] = ZIO.succeed(metricNameValue)
    def startTime: ZIO[Any, Nothing, primitives.Timestamp] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, primitives.Timestamp] = ZIO.succeed(endTimeValue)
    def period: ZIO[Any, Nothing, primitives.MetricPeriod] = ZIO.succeed(periodValue)
    def unit: ZIO[Any, Nothing, MetricUnit] = ZIO.succeed(unitValue)
    def statistics: ZIO[Any, Nothing, List[MetricStatistic]] = ZIO.succeed(statisticsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest) extends GetDistributionMetricDataRequest.ReadOnly {
    override def distributionNameValue: primitives.ResourceName = impl.distributionName(): primitives.ResourceName
    override def metricNameValue: DistributionMetricName = DistributionMetricName.wrap(impl.metricName())
    override def startTimeValue: primitives.Timestamp = impl.startTime(): primitives.Timestamp
    override def endTimeValue: primitives.Timestamp = impl.endTime(): primitives.Timestamp
    override def periodValue: primitives.MetricPeriod = impl.period(): primitives.MetricPeriod
    override def unitValue: MetricUnit = MetricUnit.wrap(impl.unit())
    override def statisticsValue: List[MetricStatistic] = impl.statistics().asScala.map { item => 
      MetricStatistic.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest): ReadOnly = new Wrapper(impl)
}