package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ExportSnapshotRecord(name: scala.Option[primitives.ResourceName] = None, arn: scala.Option[primitives.NonEmptyString] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, resourceType: scala.Option[ResourceType] = None, state: scala.Option[RecordState] = None, sourceInfo: scala.Option[ExportSnapshotRecordSourceInfo] = None, destinationInfo: scala.Option[DestinationInfo] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord = {
    import ExportSnapshotRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(state.map(value => value.unwrap))(_.state).optionallyWith(sourceInfo.map(value => value.buildAwsValue()))(_.sourceInfo).optionallyWith(destinationInfo.map(value => value.buildAwsValue()))(_.destinationInfo).build()
  }
  def asReadOnly: ExportSnapshotRecord.ReadOnly = ExportSnapshotRecord.wrap(buildAwsValue())
}
object ExportSnapshotRecord {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ExportSnapshotRecord = ExportSnapshotRecord(nameValue.map(value => value), arnValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), resourceTypeValue.map(value => value), stateValue.map(value => value), sourceInfoValue.map(value => value.editable), destinationInfoValue.map(value => value.editable))
    def nameValue: scala.Option[primitives.ResourceName]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def resourceTypeValue: scala.Option[ResourceType]
    def stateValue: scala.Option[RecordState]
    def sourceInfoValue: scala.Option[ExportSnapshotRecordSourceInfo.ReadOnly]
    def destinationInfoValue: scala.Option[DestinationInfo.ReadOnly]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RecordState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def sourceInfo: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ExportSnapshotRecordSourceInfo.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceInfo", sourceInfoValue)
    def destinationInfo: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DestinationInfo.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("destinationInfo", destinationInfoValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord) extends ExportSnapshotRecord.ReadOnly {
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def stateValue: scala.Option[RecordState] = scala.Option(impl.state()).map(value => RecordState.wrap(value))
    override def sourceInfoValue: scala.Option[ExportSnapshotRecordSourceInfo.ReadOnly] = scala.Option(impl.sourceInfo()).map(value => ExportSnapshotRecordSourceInfo.wrap(value))
    override def destinationInfoValue: scala.Option[DestinationInfo.ReadOnly] = scala.Option(impl.destinationInfo()).map(value => DestinationInfo.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord): ReadOnly = new Wrapper(impl)
}