package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DiskSnapshotInfo(sizeInGb: scala.Option[primitives.Integer] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo = {
    import DiskSnapshotInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo.builder().optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(_.sizeInGb).build()
  }
  def asReadOnly: DiskSnapshotInfo.ReadOnly = DiskSnapshotInfo.wrap(buildAwsValue())
}
object DiskSnapshotInfo {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DiskSnapshotInfo = DiskSnapshotInfo(sizeInGbValue.map(value => value))
    def sizeInGbValue: scala.Option[primitives.Integer]
    def sizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sizeInGb", sizeInGbValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo) extends DiskSnapshotInfo.ReadOnly { override def sizeInGbValue: scala.Option[primitives.Integer] = scala.Option(impl.sizeInGb()).map(value => value: primitives.Integer) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo): ReadOnly = new Wrapper(impl)
}