package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDistributionResponse(distribution: scala.Option[LightsailDistribution] = None, operation: scala.Option[Operation] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse = {
    import CreateDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse.builder().optionallyWith(distribution.map(value => value.buildAwsValue()))(_.distribution).optionallyWith(operation.map(value => value.buildAwsValue()))(_.operation).build()
  }
  def asReadOnly: CreateDistributionResponse.ReadOnly = CreateDistributionResponse.wrap(buildAwsValue())
}
object CreateDistributionResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDistributionResponse = CreateDistributionResponse(distributionValue.map(value => value.editable), operationValue.map(value => value.editable))
    def distributionValue: scala.Option[LightsailDistribution.ReadOnly]
    def operationValue: scala.Option[Operation.ReadOnly]
    def distribution: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LightsailDistribution.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("distribution", distributionValue)
    def operation: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Operation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operation", operationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse) extends CreateDistributionResponse.ReadOnly {
    override def distributionValue: scala.Option[LightsailDistribution.ReadOnly] = scala.Option(impl.distribution()).map(value => LightsailDistribution.wrap(value))
    override def operationValue: scala.Option[Operation.ReadOnly] = scala.Option(impl.operation()).map(value => Operation.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse): ReadOnly = new Wrapper(impl)
}