package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateContainerServiceRegistryLoginResponse(registryLogin: scala.Option[ContainerServiceRegistryLogin] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse = {
    import CreateContainerServiceRegistryLoginResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse.builder().optionallyWith(registryLogin.map(value => value.buildAwsValue()))(_.registryLogin).build()
  }
  def asReadOnly: CreateContainerServiceRegistryLoginResponse.ReadOnly = CreateContainerServiceRegistryLoginResponse.wrap(buildAwsValue())
}
object CreateContainerServiceRegistryLoginResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateContainerServiceRegistryLoginResponse = CreateContainerServiceRegistryLoginResponse(registryLoginValue.map(value => value.editable))
    def registryLoginValue: scala.Option[ContainerServiceRegistryLogin.ReadOnly]
    def registryLogin: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerServiceRegistryLogin.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("registryLogin", registryLoginValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse) extends CreateContainerServiceRegistryLoginResponse.ReadOnly { override def registryLoginValue: scala.Option[ContainerServiceRegistryLogin.ReadOnly] = scala.Option(impl.registryLogin()).map(value => ContainerServiceRegistryLogin.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse): ReadOnly = new Wrapper(impl)
}