package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CopySnapshotRequest(sourceSnapshotName: scala.Option[primitives.ResourceName] = None, sourceResourceName: scala.Option[String] = None, restoreDate: scala.Option[String] = None, useLatestRestorableAutoSnapshot: scala.Option[Boolean] = None, targetSnapshotName: primitives.ResourceName, sourceRegion: RegionName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest = {
    import CopySnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest.builder().optionallyWith(sourceSnapshotName.map(value => value: java.lang.String))(_.sourceSnapshotName).optionallyWith(sourceResourceName.map(value => value: java.lang.String))(_.sourceResourceName).optionallyWith(restoreDate.map(value => value: java.lang.String))(_.restoreDate).optionallyWith(useLatestRestorableAutoSnapshot.map(value => value: java.lang.Boolean))(_.useLatestRestorableAutoSnapshot).targetSnapshotName(targetSnapshotName: java.lang.String).sourceRegion(sourceRegion.unwrap).build()
  }
  def asReadOnly: CopySnapshotRequest.ReadOnly = CopySnapshotRequest.wrap(buildAwsValue())
}
object CopySnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CopySnapshotRequest = CopySnapshotRequest(sourceSnapshotNameValue.map(value => value), sourceResourceNameValue.map(value => value), restoreDateValue.map(value => value), useLatestRestorableAutoSnapshotValue.map(value => value), targetSnapshotNameValue, sourceRegionValue)
    def sourceSnapshotNameValue: scala.Option[primitives.ResourceName]
    def sourceResourceNameValue: scala.Option[String]
    def restoreDateValue: scala.Option[String]
    def useLatestRestorableAutoSnapshotValue: scala.Option[Boolean]
    def targetSnapshotNameValue: primitives.ResourceName
    def sourceRegionValue: RegionName
    def sourceSnapshotName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceSnapshotName", sourceSnapshotNameValue)
    def sourceResourceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceResourceName", sourceResourceNameValue)
    def restoreDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("restoreDate", restoreDateValue)
    def useLatestRestorableAutoSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("useLatestRestorableAutoSnapshot", useLatestRestorableAutoSnapshotValue)
    def targetSnapshotName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(targetSnapshotNameValue)
    def sourceRegion: ZIO[Any, Nothing, RegionName] = ZIO.succeed(sourceRegionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest) extends CopySnapshotRequest.ReadOnly {
    override def sourceSnapshotNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.sourceSnapshotName()).map(value => value: primitives.ResourceName)
    override def sourceResourceNameValue: scala.Option[String] = scala.Option(impl.sourceResourceName()).map(value => value: String)
    override def restoreDateValue: scala.Option[String] = scala.Option(impl.restoreDate()).map(value => value: String)
    override def useLatestRestorableAutoSnapshotValue: scala.Option[Boolean] = scala.Option(impl.useLatestRestorableAutoSnapshot()).map(value => value: Boolean)
    override def targetSnapshotNameValue: primitives.ResourceName = impl.targetSnapshotName(): primitives.ResourceName
    override def sourceRegionValue: RegionName = RegionName.wrap(impl.sourceRegion())
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest): ReadOnly = new Wrapper(impl)
}