package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ContainerServiceState { def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceState }
object ContainerServiceState {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.ContainerServiceState): ContainerServiceState = value match {
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.DEPLOYING =>
      val r = DEPLOYING
      r
  }
  case object unknownToSdkVersion extends ContainerServiceState { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceState = software.amazon.awssdk.services.lightsail.model.ContainerServiceState.UNKNOWN_TO_SDK_VERSION }
  case object PENDING extends ContainerServiceState { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceState = software.amazon.awssdk.services.lightsail.model.ContainerServiceState.PENDING }
  case object READY extends ContainerServiceState { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceState = software.amazon.awssdk.services.lightsail.model.ContainerServiceState.READY }
  case object RUNNING extends ContainerServiceState { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceState = software.amazon.awssdk.services.lightsail.model.ContainerServiceState.RUNNING }
  case object UPDATING extends ContainerServiceState { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceState = software.amazon.awssdk.services.lightsail.model.ContainerServiceState.UPDATING }
  case object DELETING extends ContainerServiceState { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceState = software.amazon.awssdk.services.lightsail.model.ContainerServiceState.DELETING }
  case object DISABLED extends ContainerServiceState { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceState = software.amazon.awssdk.services.lightsail.model.ContainerServiceState.DISABLED }
  case object DEPLOYING extends ContainerServiceState { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceState = software.amazon.awssdk.services.lightsail.model.ContainerServiceState.DEPLOYING }
}