package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AvailabilityZone(zoneName: scala.Option[primitives.NonEmptyString] = None, state: scala.Option[primitives.NonEmptyString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AvailabilityZone = {
    import AvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AvailabilityZone.builder().optionallyWith(zoneName.map(value => value: java.lang.String))(_.zoneName).optionallyWith(state.map(value => value: java.lang.String))(_.state).build()
  }
  def asReadOnly: AvailabilityZone.ReadOnly = AvailabilityZone.wrap(buildAwsValue())
}
object AvailabilityZone {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.AvailabilityZone] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AvailabilityZone = AvailabilityZone(zoneNameValue.map(value => value), stateValue.map(value => value))
    def zoneNameValue: scala.Option[primitives.NonEmptyString]
    def stateValue: scala.Option[primitives.NonEmptyString]
    def zoneName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("zoneName", zoneNameValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.AvailabilityZone) extends AvailabilityZone.ReadOnly {
    override def zoneNameValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.zoneName()).map(value => value: primitives.NonEmptyString)
    override def stateValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.state()).map(value => value: primitives.NonEmptyString)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.AvailabilityZone): ReadOnly = new Wrapper(impl)
}