package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AttachDiskRequest(diskName: primitives.ResourceName, instanceName: primitives.ResourceName, diskPath: primitives.NonEmptyString) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AttachDiskRequest = {
    import AttachDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachDiskRequest.builder().diskName(diskName: java.lang.String).instanceName(instanceName: java.lang.String).diskPath(diskPath: java.lang.String).build()
  }
  def asReadOnly: AttachDiskRequest.ReadOnly = AttachDiskRequest.wrap(buildAwsValue())
}
object AttachDiskRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.AttachDiskRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AttachDiskRequest = AttachDiskRequest(diskNameValue, instanceNameValue, diskPathValue)
    def diskNameValue: primitives.ResourceName
    def instanceNameValue: primitives.ResourceName
    def diskPathValue: primitives.NonEmptyString
    def diskName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(diskNameValue)
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
    def diskPath: ZIO[Any, Nothing, primitives.NonEmptyString] = ZIO.succeed(diskPathValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.AttachDiskRequest) extends AttachDiskRequest.ReadOnly {
    override def diskNameValue: primitives.ResourceName = impl.diskName(): primitives.ResourceName
    override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName
    override def diskPathValue: primitives.NonEmptyString = impl.diskPath(): primitives.NonEmptyString
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.AttachDiskRequest): ReadOnly = new Wrapper(impl)
}