package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AttachCertificateToDistributionRequest(distributionName: primitives.ResourceName, certificateName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest = {
    import AttachCertificateToDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest.builder().distributionName(distributionName: java.lang.String).certificateName(certificateName: java.lang.String).build()
  }
  def asReadOnly: AttachCertificateToDistributionRequest.ReadOnly = AttachCertificateToDistributionRequest.wrap(buildAwsValue())
}
object AttachCertificateToDistributionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AttachCertificateToDistributionRequest = AttachCertificateToDistributionRequest(distributionNameValue, certificateNameValue)
    def distributionNameValue: primitives.ResourceName
    def certificateNameValue: primitives.ResourceName
    def distributionName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(distributionNameValue)
    def certificateName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(certificateNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest) extends AttachCertificateToDistributionRequest.ReadOnly {
    override def distributionNameValue: primitives.ResourceName = impl.distributionName(): primitives.ResourceName
    override def certificateNameValue: primitives.ResourceName = impl.certificateName(): primitives.ResourceName
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest): ReadOnly = new Wrapper(impl)
}