package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AddOn(name: scala.Option[String] = None, status: scala.Option[String] = None, snapshotTimeOfDay: scala.Option[primitives.TimeOfDay] = None, nextSnapshotTimeOfDay: scala.Option[primitives.TimeOfDay] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AddOn = {
    import AddOn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AddOn.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(snapshotTimeOfDay.map(value => value: java.lang.String))(_.snapshotTimeOfDay).optionallyWith(nextSnapshotTimeOfDay.map(value => value: java.lang.String))(_.nextSnapshotTimeOfDay).build()
  }
  def asReadOnly: AddOn.ReadOnly = AddOn.wrap(buildAwsValue())
}
object AddOn {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.AddOn] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AddOn = AddOn(nameValue.map(value => value), statusValue.map(value => value), snapshotTimeOfDayValue.map(value => value), nextSnapshotTimeOfDayValue.map(value => value))
    def nameValue: scala.Option[String]
    def statusValue: scala.Option[String]
    def snapshotTimeOfDayValue: scala.Option[primitives.TimeOfDay]
    def nextSnapshotTimeOfDayValue: scala.Option[primitives.TimeOfDay]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def snapshotTimeOfDay: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TimeOfDay] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snapshotTimeOfDay", snapshotTimeOfDayValue)
    def nextSnapshotTimeOfDay: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TimeOfDay] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextSnapshotTimeOfDay", nextSnapshotTimeOfDayValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.AddOn) extends AddOn.ReadOnly {
    override def nameValue: scala.Option[String] = scala.Option(impl.name()).map(value => value: String)
    override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
    override def snapshotTimeOfDayValue: scala.Option[primitives.TimeOfDay] = scala.Option(impl.snapshotTimeOfDay()).map(value => value: primitives.TimeOfDay)
    override def nextSnapshotTimeOfDayValue: scala.Option[primitives.TimeOfDay] = scala.Option(impl.nextSnapshotTimeOfDay()).map(value => value: primitives.TimeOfDay)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.AddOn): ReadOnly = new Wrapper(impl)
}