package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RebootInstanceRequest(instanceName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest = {
    import RebootInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest.builder().instanceName(instanceName: java.lang.String).build()
  }
  def asReadOnly: RebootInstanceRequest.ReadOnly = RebootInstanceRequest.wrap(buildAwsValue())
}
object RebootInstanceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RebootInstanceRequest = RebootInstanceRequest(instanceNameValue)
    def instanceNameValue: primitives.ResourceName
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest) extends RebootInstanceRequest.ReadOnly { override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest): ReadOnly = new Wrapper(impl)
}