package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetStaticIpsResponse(staticIps: scala.Option[Iterable[StaticIp]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse = {
    import GetStaticIpsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse.builder().optionallyWith(staticIps.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.staticIps).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetStaticIpsResponse.ReadOnly = GetStaticIpsResponse.wrap(buildAwsValue())
}
object GetStaticIpsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetStaticIpsResponse = GetStaticIpsResponse(staticIpsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def staticIpsValue: scala.Option[List[StaticIp.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def staticIps: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[StaticIp.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("staticIps", staticIpsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse) extends GetStaticIpsResponse.ReadOnly {
    override def staticIpsValue: scala.Option[List[StaticIp.ReadOnly]] = scala.Option(impl.staticIps()).map(value => value.asScala.map { item => 
      StaticIp.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse): ReadOnly = new Wrapper(impl)
}