package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseParametersResponse(parameters: scala.Option[Iterable[RelationalDatabaseParameter]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse = {
    import GetRelationalDatabaseParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse.builder().optionallyWith(parameters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.parameters).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetRelationalDatabaseParametersResponse.ReadOnly = GetRelationalDatabaseParametersResponse.wrap(buildAwsValue())
}
object GetRelationalDatabaseParametersResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseParametersResponse = GetRelationalDatabaseParametersResponse(parametersValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def parametersValue: scala.Option[List[RelationalDatabaseParameter.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def parameters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RelationalDatabaseParameter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parameters", parametersValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse) extends GetRelationalDatabaseParametersResponse.ReadOnly {
    override def parametersValue: scala.Option[List[RelationalDatabaseParameter.ReadOnly]] = scala.Option(impl.parameters()).map(value => value.asScala.map { item => 
      RelationalDatabaseParameter.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse): ReadOnly = new Wrapper(impl)
}