package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseMasterUserPasswordRequest(relationalDatabaseName: primitives.ResourceName, passwordVersion: scala.Option[RelationalDatabasePasswordVersion] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest = {
    import GetRelationalDatabaseMasterUserPasswordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).optionallyWith(passwordVersion.map(value => value.unwrap))(_.passwordVersion).build()
  }
  def asReadOnly: GetRelationalDatabaseMasterUserPasswordRequest.ReadOnly = GetRelationalDatabaseMasterUserPasswordRequest.wrap(buildAwsValue())
}
object GetRelationalDatabaseMasterUserPasswordRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseMasterUserPasswordRequest = GetRelationalDatabaseMasterUserPasswordRequest(relationalDatabaseNameValue, passwordVersionValue.map(value => value))
    def relationalDatabaseNameValue: primitives.ResourceName
    def passwordVersionValue: scala.Option[RelationalDatabasePasswordVersion]
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
    def passwordVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RelationalDatabasePasswordVersion] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("passwordVersion", passwordVersionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest) extends GetRelationalDatabaseMasterUserPasswordRequest.ReadOnly {
    override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName
    override def passwordVersionValue: scala.Option[RelationalDatabasePasswordVersion] = scala.Option(impl.passwordVersion()).map(value => RelationalDatabasePasswordVersion.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest): ReadOnly = new Wrapper(impl)
}