package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetInstanceSnapshotRequest(instanceSnapshotName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest = {
    import GetInstanceSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest.builder().instanceSnapshotName(instanceSnapshotName: java.lang.String).build()
  }
  def asReadOnly: GetInstanceSnapshotRequest.ReadOnly = GetInstanceSnapshotRequest.wrap(buildAwsValue())
}
object GetInstanceSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetInstanceSnapshotRequest = GetInstanceSnapshotRequest(instanceSnapshotNameValue)
    def instanceSnapshotNameValue: primitives.ResourceName
    def instanceSnapshotName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceSnapshotNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest) extends GetInstanceSnapshotRequest.ReadOnly { override def instanceSnapshotNameValue: primitives.ResourceName = impl.instanceSnapshotName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest): ReadOnly = new Wrapper(impl)
}