package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDisksRequest(pageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDisksRequest = {
    import GetDisksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDisksRequest.builder().optionallyWith(pageToken.map(value => value: java.lang.String))(_.pageToken).build()
  }
  def asReadOnly: GetDisksRequest.ReadOnly = GetDisksRequest.wrap(buildAwsValue())
}
object GetDisksRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDisksRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDisksRequest = GetDisksRequest(pageTokenValue.map(value => value))
    def pageTokenValue: scala.Option[String]
    def pageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDisksRequest) extends GetDisksRequest.ReadOnly { override def pageTokenValue: scala.Option[String] = scala.Option(impl.pageToken()).map(value => value: String) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDisksRequest): ReadOnly = new Wrapper(impl)
}