package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetBucketBundlesResponse(bundles: scala.Option[Iterable[BucketBundle]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse = {
    import GetBucketBundlesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse.builder().optionallyWith(bundles.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.bundles).build()
  }
  def asReadOnly: GetBucketBundlesResponse.ReadOnly = GetBucketBundlesResponse.wrap(buildAwsValue())
}
object GetBucketBundlesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetBucketBundlesResponse = GetBucketBundlesResponse(bundlesValue.map(value => value.map { item => 
      item.editable
    }))
    def bundlesValue: scala.Option[List[BucketBundle.ReadOnly]]
    def bundles: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[BucketBundle.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bundles", bundlesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse) extends GetBucketBundlesResponse.ReadOnly {
    override def bundlesValue: scala.Option[List[BucketBundle.ReadOnly]] = scala.Option(impl.bundles()).map(value => value.asScala.map { item => 
      BucketBundle.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse): ReadOnly = new Wrapper(impl)
}