package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ForwardValues { def unwrap: software.amazon.awssdk.services.lightsail.model.ForwardValues }
object ForwardValues {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.ForwardValues): ForwardValues = value match {
    case software.amazon.awssdk.services.lightsail.model.ForwardValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ForwardValues.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.lightsail.model.ForwardValues.ALLOW_LIST =>
      val r = `allow-list`
      r
    case software.amazon.awssdk.services.lightsail.model.ForwardValues.ALL =>
      val r = all
      r
  }
  case object unknownToSdkVersion extends ForwardValues { override def unwrap: software.amazon.awssdk.services.lightsail.model.ForwardValues = software.amazon.awssdk.services.lightsail.model.ForwardValues.UNKNOWN_TO_SDK_VERSION }
  case object none extends ForwardValues { override def unwrap: software.amazon.awssdk.services.lightsail.model.ForwardValues = software.amazon.awssdk.services.lightsail.model.ForwardValues.NONE }
  case object `allow-list` extends ForwardValues { override def unwrap: software.amazon.awssdk.services.lightsail.model.ForwardValues = software.amazon.awssdk.services.lightsail.model.ForwardValues.ALLOW_LIST }
  case object all extends ForwardValues { override def unwrap: software.amazon.awssdk.services.lightsail.model.ForwardValues = software.amazon.awssdk.services.lightsail.model.ForwardValues.ALL }
}