package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DetachStaticIpRequest(staticIpName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest = {
    import DetachStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest.builder().staticIpName(staticIpName: java.lang.String).build()
  }
  def asReadOnly: DetachStaticIpRequest.ReadOnly = DetachStaticIpRequest.wrap(buildAwsValue())
}
object DetachStaticIpRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DetachStaticIpRequest = DetachStaticIpRequest(staticIpNameValue)
    def staticIpNameValue: primitives.ResourceName
    def staticIpName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(staticIpNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest) extends DetachStaticIpRequest.ReadOnly { override def staticIpNameValue: primitives.ResourceName = impl.staticIpName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest): ReadOnly = new Wrapper(impl)
}