package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateInstancesRequest(instanceNames: Iterable[String], availabilityZone: String, customImageName: scala.Option[primitives.ResourceName] = None, blueprintId: primitives.NonEmptyString, bundleId: primitives.NonEmptyString, userData: scala.Option[String] = None, keyPairName: scala.Option[primitives.ResourceName] = None, tags: scala.Option[Iterable[Tag]] = None, addOns: scala.Option[Iterable[AddOnRequest]] = None, ipAddressType: scala.Option[IpAddressType] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest = {
    import CreateInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest.builder().instanceNames(instanceNames.map { item => 
      item: java.lang.String
    }.asJavaCollection).availabilityZone(availabilityZone: java.lang.String).optionallyWith(customImageName.map(value => value: java.lang.String))(_.customImageName).blueprintId(blueprintId: java.lang.String).bundleId(bundleId: java.lang.String).optionallyWith(userData.map(value => value: java.lang.String))(_.userData).optionallyWith(keyPairName.map(value => value: java.lang.String))(_.keyPairName).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(addOns.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.addOns).optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType).build()
  }
  def asReadOnly: CreateInstancesRequest.ReadOnly = CreateInstancesRequest.wrap(buildAwsValue())
}
object CreateInstancesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateInstancesRequest = CreateInstancesRequest(instanceNamesValue, availabilityZoneValue, customImageNameValue.map(value => value), blueprintIdValue, bundleIdValue, userDataValue.map(value => value), keyPairNameValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), addOnsValue.map(value => value.map { item => 
      item.editable
    }), ipAddressTypeValue.map(value => value))
    def instanceNamesValue: List[String]
    def availabilityZoneValue: String
    def customImageNameValue: scala.Option[primitives.ResourceName]
    def blueprintIdValue: primitives.NonEmptyString
    def bundleIdValue: primitives.NonEmptyString
    def userDataValue: scala.Option[String]
    def keyPairNameValue: scala.Option[primitives.ResourceName]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def addOnsValue: scala.Option[List[AddOnRequest.ReadOnly]]
    def ipAddressTypeValue: scala.Option[IpAddressType]
    def instanceNames: ZIO[Any, Nothing, List[String]] = ZIO.succeed(instanceNamesValue)
    def availabilityZone: ZIO[Any, Nothing, String] = ZIO.succeed(availabilityZoneValue)
    def customImageName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customImageName", customImageNameValue)
    def blueprintId: ZIO[Any, Nothing, primitives.NonEmptyString] = ZIO.succeed(blueprintIdValue)
    def bundleId: ZIO[Any, Nothing, primitives.NonEmptyString] = ZIO.succeed(bundleIdValue)
    def userData: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("userData", userDataValue)
    def keyPairName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("keyPairName", keyPairNameValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def addOns: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AddOnRequest.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addOns", addOnsValue)
    def ipAddressType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, IpAddressType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ipAddressType", ipAddressTypeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest) extends CreateInstancesRequest.ReadOnly {
    override def instanceNamesValue: List[String] = impl.instanceNames().asScala.map { item => 
      item: String
    }.toList
    override def availabilityZoneValue: String = impl.availabilityZone(): String
    override def customImageNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.customImageName()).map(value => value: primitives.ResourceName)
    override def blueprintIdValue: primitives.NonEmptyString = impl.blueprintId(): primitives.NonEmptyString
    override def bundleIdValue: primitives.NonEmptyString = impl.bundleId(): primitives.NonEmptyString
    override def userDataValue: scala.Option[String] = scala.Option(impl.userData()).map(value => value: String)
    override def keyPairNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.keyPairName()).map(value => value: primitives.ResourceName)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def addOnsValue: scala.Option[List[AddOnRequest.ReadOnly]] = scala.Option(impl.addOns()).map(value => value.asScala.map { item => 
      AddOnRequest.wrap(item)
    }.toList)
    override def ipAddressTypeValue: scala.Option[IpAddressType] = scala.Option(impl.ipAddressType()).map(value => IpAddressType.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest): ReadOnly = new Wrapper(impl)
}