package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDomainResponse(operation: scala.Option[Operation] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateDomainResponse = {
    import CreateDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDomainResponse.builder().optionallyWith(operation.map(value => value.buildAwsValue()))(_.operation).build()
  }
  def asReadOnly: CreateDomainResponse.ReadOnly = CreateDomainResponse.wrap(buildAwsValue())
}
object CreateDomainResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateDomainResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDomainResponse = CreateDomainResponse(operationValue.map(value => value.editable))
    def operationValue: scala.Option[Operation.ReadOnly]
    def operation: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Operation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operation", operationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateDomainResponse) extends CreateDomainResponse.ReadOnly { override def operationValue: scala.Option[Operation.ReadOnly] = scala.Option(impl.operation()).map(value => Operation.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateDomainResponse): ReadOnly = new Wrapper(impl)
}