package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateCloudFormationStackRequest(instances: Iterable[InstanceEntry]) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest = {
    import CreateCloudFormationStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest.builder().instances(instances.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).build()
  }
  def asReadOnly: CreateCloudFormationStackRequest.ReadOnly = CreateCloudFormationStackRequest.wrap(buildAwsValue())
}
object CreateCloudFormationStackRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateCloudFormationStackRequest = CreateCloudFormationStackRequest(instancesValue.map { item => 
      item.editable
    })
    def instancesValue: List[InstanceEntry.ReadOnly]
    def instances: ZIO[Any, Nothing, List[InstanceEntry.ReadOnly]] = ZIO.succeed(instancesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest) extends CreateCloudFormationStackRequest.ReadOnly {
    override def instancesValue: List[InstanceEntry.ReadOnly] = impl.instances().asScala.map { item => 
      InstanceEntry.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest): ReadOnly = new Wrapper(impl)
}