package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Certificate(arn: scala.Option[primitives.NonEmptyString] = None, name: scala.Option[primitives.CertificateName] = None, domainName: scala.Option[primitives.DomainName] = None, status: scala.Option[CertificateStatus] = None, serialNumber: scala.Option[primitives.SerialNumber] = None, subjectAlternativeNames: scala.Option[Iterable[primitives.DomainName]] = None, domainValidationRecords: scala.Option[Iterable[DomainValidationRecord]] = None, requestFailureReason: scala.Option[primitives.RequestFailureReason] = None, inUseResourceCount: scala.Option[primitives.InUseResourceCount] = None, keyAlgorithm: scala.Option[primitives.KeyAlgorithm] = None, createdAt: scala.Option[primitives.IsoDate] = None, issuedAt: scala.Option[primitives.IsoDate] = None, issuerCA: scala.Option[primitives.IssuerCA] = None, notBefore: scala.Option[primitives.IsoDate] = None, notAfter: scala.Option[primitives.IsoDate] = None, eligibleToRenew: scala.Option[primitives.EligibleToRenew] = None, renewalSummary: scala.Option[RenewalSummary] = None, revokedAt: scala.Option[primitives.IsoDate] = None, revocationReason: scala.Option[primitives.RevocationReason] = None, tags: scala.Option[Iterable[Tag]] = None, supportCode: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Certificate.builder().optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(domainName.map(value => value: java.lang.String))(_.domainName).optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(serialNumber.map(value => value: java.lang.String))(_.serialNumber).optionallyWith(subjectAlternativeNames.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.subjectAlternativeNames).optionallyWith(domainValidationRecords.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.domainValidationRecords).optionallyWith(requestFailureReason.map(value => value: java.lang.String))(_.requestFailureReason).optionallyWith(inUseResourceCount.map(value => value: java.lang.Integer))(_.inUseResourceCount).optionallyWith(keyAlgorithm.map(value => value: java.lang.String))(_.keyAlgorithm).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(issuedAt.map(value => value: java.time.Instant))(_.issuedAt).optionallyWith(issuerCA.map(value => value: java.lang.String))(_.issuerCA).optionallyWith(notBefore.map(value => value: java.time.Instant))(_.notBefore).optionallyWith(notAfter.map(value => value: java.time.Instant))(_.notAfter).optionallyWith(eligibleToRenew.map(value => value: java.lang.String))(_.eligibleToRenew).optionallyWith(renewalSummary.map(value => value.buildAwsValue()))(_.renewalSummary).optionallyWith(revokedAt.map(value => value: java.time.Instant))(_.revokedAt).optionallyWith(revocationReason.map(value => value: java.lang.String))(_.revocationReason).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(supportCode.map(value => value: java.lang.String))(_.supportCode).build()
  }
  def asReadOnly: Certificate.ReadOnly = Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.Certificate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Certificate = Certificate(arnValue.map(value => value), nameValue.map(value => value), domainNameValue.map(value => value), statusValue.map(value => value), serialNumberValue.map(value => value), subjectAlternativeNamesValue.map(value => value), domainValidationRecordsValue.map(value => value.map { item => 
      item.editable
    }), requestFailureReasonValue.map(value => value), inUseResourceCountValue.map(value => value), keyAlgorithmValue.map(value => value), createdAtValue.map(value => value), issuedAtValue.map(value => value), issuerCAValue.map(value => value), notBeforeValue.map(value => value), notAfterValue.map(value => value), eligibleToRenewValue.map(value => value), renewalSummaryValue.map(value => value.editable), revokedAtValue.map(value => value), revocationReasonValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), supportCodeValue.map(value => value))
    def arnValue: scala.Option[primitives.NonEmptyString]
    def nameValue: scala.Option[primitives.CertificateName]
    def domainNameValue: scala.Option[primitives.DomainName]
    def statusValue: scala.Option[CertificateStatus]
    def serialNumberValue: scala.Option[primitives.SerialNumber]
    def subjectAlternativeNamesValue: scala.Option[List[primitives.DomainName]]
    def domainValidationRecordsValue: scala.Option[List[DomainValidationRecord.ReadOnly]]
    def requestFailureReasonValue: scala.Option[primitives.RequestFailureReason]
    def inUseResourceCountValue: scala.Option[primitives.InUseResourceCount]
    def keyAlgorithmValue: scala.Option[primitives.KeyAlgorithm]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def issuedAtValue: scala.Option[primitives.IsoDate]
    def issuerCAValue: scala.Option[primitives.IssuerCA]
    def notBeforeValue: scala.Option[primitives.IsoDate]
    def notAfterValue: scala.Option[primitives.IsoDate]
    def eligibleToRenewValue: scala.Option[primitives.EligibleToRenew]
    def renewalSummaryValue: scala.Option[RenewalSummary.ReadOnly]
    def revokedAtValue: scala.Option[primitives.IsoDate]
    def revocationReasonValue: scala.Option[primitives.RevocationReason]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def supportCodeValue: scala.Option[String]
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CertificateName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def domainName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DomainName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainName", domainNameValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CertificateStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def serialNumber: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SerialNumber] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("serialNumber", serialNumberValue)
    def subjectAlternativeNames: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.DomainName]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subjectAlternativeNames", subjectAlternativeNamesValue)
    def domainValidationRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DomainValidationRecord.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainValidationRecords", domainValidationRecordsValue)
    def requestFailureReason: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RequestFailureReason] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("requestFailureReason", requestFailureReasonValue)
    def inUseResourceCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.InUseResourceCount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inUseResourceCount", inUseResourceCountValue)
    def keyAlgorithm: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.KeyAlgorithm] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("keyAlgorithm", keyAlgorithmValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def issuedAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("issuedAt", issuedAtValue)
    def issuerCA: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IssuerCA] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("issuerCA", issuerCAValue)
    def notBefore: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notBefore", notBeforeValue)
    def notAfter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notAfter", notAfterValue)
    def eligibleToRenew: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.EligibleToRenew] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eligibleToRenew", eligibleToRenewValue)
    def renewalSummary: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RenewalSummary.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("renewalSummary", renewalSummaryValue)
    def revokedAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("revokedAt", revokedAtValue)
    def revocationReason: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RevocationReason] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("revocationReason", revocationReasonValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def supportCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportCode", supportCodeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.Certificate) extends Certificate.ReadOnly {
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def nameValue: scala.Option[primitives.CertificateName] = scala.Option(impl.name()).map(value => value: primitives.CertificateName)
    override def domainNameValue: scala.Option[primitives.DomainName] = scala.Option(impl.domainName()).map(value => value: primitives.DomainName)
    override def statusValue: scala.Option[CertificateStatus] = scala.Option(impl.status()).map(value => CertificateStatus.wrap(value))
    override def serialNumberValue: scala.Option[primitives.SerialNumber] = scala.Option(impl.serialNumber()).map(value => value: primitives.SerialNumber)
    override def subjectAlternativeNamesValue: scala.Option[List[primitives.DomainName]] = scala.Option(impl.subjectAlternativeNames()).map(value => value.asScala.map { item => 
      item: primitives.DomainName
    }.toList)
    override def domainValidationRecordsValue: scala.Option[List[DomainValidationRecord.ReadOnly]] = scala.Option(impl.domainValidationRecords()).map(value => value.asScala.map { item => 
      DomainValidationRecord.wrap(item)
    }.toList)
    override def requestFailureReasonValue: scala.Option[primitives.RequestFailureReason] = scala.Option(impl.requestFailureReason()).map(value => value: primitives.RequestFailureReason)
    override def inUseResourceCountValue: scala.Option[primitives.InUseResourceCount] = scala.Option(impl.inUseResourceCount()).map(value => value: primitives.InUseResourceCount)
    override def keyAlgorithmValue: scala.Option[primitives.KeyAlgorithm] = scala.Option(impl.keyAlgorithm()).map(value => value: primitives.KeyAlgorithm)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def issuedAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.issuedAt()).map(value => value: primitives.IsoDate)
    override def issuerCAValue: scala.Option[primitives.IssuerCA] = scala.Option(impl.issuerCA()).map(value => value: primitives.IssuerCA)
    override def notBeforeValue: scala.Option[primitives.IsoDate] = scala.Option(impl.notBefore()).map(value => value: primitives.IsoDate)
    override def notAfterValue: scala.Option[primitives.IsoDate] = scala.Option(impl.notAfter()).map(value => value: primitives.IsoDate)
    override def eligibleToRenewValue: scala.Option[primitives.EligibleToRenew] = scala.Option(impl.eligibleToRenew()).map(value => value: primitives.EligibleToRenew)
    override def renewalSummaryValue: scala.Option[RenewalSummary.ReadOnly] = scala.Option(impl.renewalSummary()).map(value => RenewalSummary.wrap(value))
    override def revokedAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.revokedAt()).map(value => value: primitives.IsoDate)
    override def revocationReasonValue: scala.Option[primitives.RevocationReason] = scala.Option(impl.revocationReason()).map(value => value: primitives.RevocationReason)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def supportCodeValue: scala.Option[String] = scala.Option(impl.supportCode()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.Certificate): ReadOnly = new Wrapper(impl)
}