package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class TagResourceRequest(resourceName: primitives.ResourceName, resourceArn: scala.Option[primitives.ResourceArn] = None, tags: Iterable[Tag]) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.TagResourceRequest.builder().resourceName(resourceName: java.lang.String).optionallyWith(resourceArn.map(value => value: java.lang.String))(_.resourceArn).tags(tags.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).build()
  }
  def asReadOnly: TagResourceRequest.ReadOnly = TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.TagResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: TagResourceRequest = TagResourceRequest(resourceNameValue, resourceArnValue.map(value => value), tagsValue.map { item => 
      item.editable
    })
    def resourceNameValue: primitives.ResourceName
    def resourceArnValue: scala.Option[primitives.ResourceArn]
    def tagsValue: List[Tag.ReadOnly]
    def resourceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(resourceNameValue)
    def resourceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceArn", resourceArnValue)
    def tags: ZIO[Any, Nothing, List[Tag.ReadOnly]] = ZIO.succeed(tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.TagResourceRequest) extends TagResourceRequest.ReadOnly {
    override def resourceNameValue: primitives.ResourceName = impl.resourceName(): primitives.ResourceName
    override def resourceArnValue: scala.Option[primitives.ResourceArn] = scala.Option(impl.resourceArn()).map(value => value: primitives.ResourceArn)
    override def tagsValue: List[Tag.ReadOnly] = impl.tags().asScala.map { item => 
      Tag.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.TagResourceRequest): ReadOnly = new Wrapper(impl)
}