package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait RelationalDatabasePasswordVersion { def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion }
object RelationalDatabasePasswordVersion {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion): RelationalDatabasePasswordVersion = value match {
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.CURRENT =>
      val r = CURRENT
      r
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.PREVIOUS =>
      val r = PREVIOUS
      r
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.PENDING =>
      val r = PENDING
      r
  }
  case object unknownToSdkVersion extends RelationalDatabasePasswordVersion { override def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion = software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.UNKNOWN_TO_SDK_VERSION }
  case object CURRENT extends RelationalDatabasePasswordVersion { override def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion = software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.CURRENT }
  case object PREVIOUS extends RelationalDatabasePasswordVersion { override def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion = software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.PREVIOUS }
  case object PENDING extends RelationalDatabasePasswordVersion { override def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion = software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.PENDING }
}