package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait OperationType { def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType }
object OperationType {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.OperationType): OperationType = value match {
    case software.amazon.awssdk.services.lightsail.model.OperationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_KNOWN_HOST_KEYS =>
      val r = DeleteKnownHostKeys
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_INSTANCE =>
      val r = DeleteInstance
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_INSTANCE =>
      val r = CreateInstance
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.STOP_INSTANCE =>
      val r = StopInstance
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.START_INSTANCE =>
      val r = StartInstance
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.REBOOT_INSTANCE =>
      val r = RebootInstance
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.OPEN_INSTANCE_PUBLIC_PORTS =>
      val r = OpenInstancePublicPorts
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.PUT_INSTANCE_PUBLIC_PORTS =>
      val r = PutInstancePublicPorts
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CLOSE_INSTANCE_PUBLIC_PORTS =>
      val r = CloseInstancePublicPorts
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.ALLOCATE_STATIC_IP =>
      val r = AllocateStaticIp
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.RELEASE_STATIC_IP =>
      val r = ReleaseStaticIp
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.ATTACH_STATIC_IP =>
      val r = AttachStaticIp
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DETACH_STATIC_IP =>
      val r = DetachStaticIp
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.UPDATE_DOMAIN_ENTRY =>
      val r = UpdateDomainEntry
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_DOMAIN_ENTRY =>
      val r = DeleteDomainEntry
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_DOMAIN =>
      val r = CreateDomain
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_DOMAIN =>
      val r = DeleteDomain
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_INSTANCE_SNAPSHOT =>
      val r = CreateInstanceSnapshot
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_INSTANCE_SNAPSHOT =>
      val r = DeleteInstanceSnapshot
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_INSTANCES_FROM_SNAPSHOT =>
      val r = CreateInstancesFromSnapshot
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_LOAD_BALANCER =>
      val r = CreateLoadBalancer
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_LOAD_BALANCER =>
      val r = DeleteLoadBalancer
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.ATTACH_INSTANCES_TO_LOAD_BALANCER =>
      val r = AttachInstancesToLoadBalancer
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DETACH_INSTANCES_FROM_LOAD_BALANCER =>
      val r = DetachInstancesFromLoadBalancer
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.UPDATE_LOAD_BALANCER_ATTRIBUTE =>
      val r = UpdateLoadBalancerAttribute
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_LOAD_BALANCER_TLS_CERTIFICATE =>
      val r = CreateLoadBalancerTlsCertificate
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_LOAD_BALANCER_TLS_CERTIFICATE =>
      val r = DeleteLoadBalancerTlsCertificate
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.ATTACH_LOAD_BALANCER_TLS_CERTIFICATE =>
      val r = AttachLoadBalancerTlsCertificate
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_DISK =>
      val r = CreateDisk
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_DISK =>
      val r = DeleteDisk
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.ATTACH_DISK =>
      val r = AttachDisk
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DETACH_DISK =>
      val r = DetachDisk
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_DISK_SNAPSHOT =>
      val r = CreateDiskSnapshot
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_DISK_SNAPSHOT =>
      val r = DeleteDiskSnapshot
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_DISK_FROM_SNAPSHOT =>
      val r = CreateDiskFromSnapshot
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_RELATIONAL_DATABASE =>
      val r = CreateRelationalDatabase
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.UPDATE_RELATIONAL_DATABASE =>
      val r = UpdateRelationalDatabase
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_RELATIONAL_DATABASE =>
      val r = DeleteRelationalDatabase
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_RELATIONAL_DATABASE_FROM_SNAPSHOT =>
      val r = CreateRelationalDatabaseFromSnapshot
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_RELATIONAL_DATABASE_SNAPSHOT =>
      val r = CreateRelationalDatabaseSnapshot
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_RELATIONAL_DATABASE_SNAPSHOT =>
      val r = DeleteRelationalDatabaseSnapshot
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.UPDATE_RELATIONAL_DATABASE_PARAMETERS =>
      val r = UpdateRelationalDatabaseParameters
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.START_RELATIONAL_DATABASE =>
      val r = StartRelationalDatabase
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.REBOOT_RELATIONAL_DATABASE =>
      val r = RebootRelationalDatabase
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.STOP_RELATIONAL_DATABASE =>
      val r = StopRelationalDatabase
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.ENABLE_ADD_ON =>
      val r = EnableAddOn
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DISABLE_ADD_ON =>
      val r = DisableAddOn
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.PUT_ALARM =>
      val r = PutAlarm
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.GET_ALARMS =>
      val r = GetAlarms
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_ALARM =>
      val r = DeleteAlarm
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.TEST_ALARM =>
      val r = TestAlarm
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_CONTACT_METHOD =>
      val r = CreateContactMethod
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.GET_CONTACT_METHODS =>
      val r = GetContactMethods
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.SEND_CONTACT_METHOD_VERIFICATION =>
      val r = SendContactMethodVerification
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_CONTACT_METHOD =>
      val r = DeleteContactMethod
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_DISTRIBUTION =>
      val r = CreateDistribution
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.UPDATE_DISTRIBUTION =>
      val r = UpdateDistribution
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_DISTRIBUTION =>
      val r = DeleteDistribution
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.RESET_DISTRIBUTION_CACHE =>
      val r = ResetDistributionCache
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.ATTACH_CERTIFICATE_TO_DISTRIBUTION =>
      val r = AttachCertificateToDistribution
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DETACH_CERTIFICATE_FROM_DISTRIBUTION =>
      val r = DetachCertificateFromDistribution
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.UPDATE_DISTRIBUTION_BUNDLE =>
      val r = UpdateDistributionBundle
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.SET_IP_ADDRESS_TYPE =>
      val r = SetIpAddressType
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_CERTIFICATE =>
      val r = CreateCertificate
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_CERTIFICATE =>
      val r = DeleteCertificate
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_CONTAINER_SERVICE =>
      val r = CreateContainerService
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.UPDATE_CONTAINER_SERVICE =>
      val r = UpdateContainerService
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_CONTAINER_SERVICE =>
      val r = DeleteContainerService
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_CONTAINER_SERVICE_DEPLOYMENT =>
      val r = CreateContainerServiceDeployment
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_CONTAINER_SERVICE_REGISTRY_LOGIN =>
      val r = CreateContainerServiceRegistryLogin
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.REGISTER_CONTAINER_IMAGE =>
      val r = RegisterContainerImage
      r
    case software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_CONTAINER_IMAGE =>
      val r = DeleteContainerImage
      r
  }
  case object unknownToSdkVersion extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.UNKNOWN_TO_SDK_VERSION }
  case object DeleteKnownHostKeys extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_KNOWN_HOST_KEYS }
  case object DeleteInstance extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_INSTANCE }
  case object CreateInstance extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_INSTANCE }
  case object StopInstance extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.STOP_INSTANCE }
  case object StartInstance extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.START_INSTANCE }
  case object RebootInstance extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.REBOOT_INSTANCE }
  case object OpenInstancePublicPorts extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.OPEN_INSTANCE_PUBLIC_PORTS }
  case object PutInstancePublicPorts extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.PUT_INSTANCE_PUBLIC_PORTS }
  case object CloseInstancePublicPorts extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CLOSE_INSTANCE_PUBLIC_PORTS }
  case object AllocateStaticIp extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.ALLOCATE_STATIC_IP }
  case object ReleaseStaticIp extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.RELEASE_STATIC_IP }
  case object AttachStaticIp extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.ATTACH_STATIC_IP }
  case object DetachStaticIp extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DETACH_STATIC_IP }
  case object UpdateDomainEntry extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.UPDATE_DOMAIN_ENTRY }
  case object DeleteDomainEntry extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_DOMAIN_ENTRY }
  case object CreateDomain extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_DOMAIN }
  case object DeleteDomain extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_DOMAIN }
  case object CreateInstanceSnapshot extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_INSTANCE_SNAPSHOT }
  case object DeleteInstanceSnapshot extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_INSTANCE_SNAPSHOT }
  case object CreateInstancesFromSnapshot extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_INSTANCES_FROM_SNAPSHOT }
  case object CreateLoadBalancer extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_LOAD_BALANCER }
  case object DeleteLoadBalancer extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_LOAD_BALANCER }
  case object AttachInstancesToLoadBalancer extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.ATTACH_INSTANCES_TO_LOAD_BALANCER }
  case object DetachInstancesFromLoadBalancer extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DETACH_INSTANCES_FROM_LOAD_BALANCER }
  case object UpdateLoadBalancerAttribute extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.UPDATE_LOAD_BALANCER_ATTRIBUTE }
  case object CreateLoadBalancerTlsCertificate extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_LOAD_BALANCER_TLS_CERTIFICATE }
  case object DeleteLoadBalancerTlsCertificate extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_LOAD_BALANCER_TLS_CERTIFICATE }
  case object AttachLoadBalancerTlsCertificate extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.ATTACH_LOAD_BALANCER_TLS_CERTIFICATE }
  case object CreateDisk extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_DISK }
  case object DeleteDisk extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_DISK }
  case object AttachDisk extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.ATTACH_DISK }
  case object DetachDisk extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DETACH_DISK }
  case object CreateDiskSnapshot extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_DISK_SNAPSHOT }
  case object DeleteDiskSnapshot extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_DISK_SNAPSHOT }
  case object CreateDiskFromSnapshot extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_DISK_FROM_SNAPSHOT }
  case object CreateRelationalDatabase extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_RELATIONAL_DATABASE }
  case object UpdateRelationalDatabase extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.UPDATE_RELATIONAL_DATABASE }
  case object DeleteRelationalDatabase extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_RELATIONAL_DATABASE }
  case object CreateRelationalDatabaseFromSnapshot extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_RELATIONAL_DATABASE_FROM_SNAPSHOT }
  case object CreateRelationalDatabaseSnapshot extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_RELATIONAL_DATABASE_SNAPSHOT }
  case object DeleteRelationalDatabaseSnapshot extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_RELATIONAL_DATABASE_SNAPSHOT }
  case object UpdateRelationalDatabaseParameters extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.UPDATE_RELATIONAL_DATABASE_PARAMETERS }
  case object StartRelationalDatabase extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.START_RELATIONAL_DATABASE }
  case object RebootRelationalDatabase extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.REBOOT_RELATIONAL_DATABASE }
  case object StopRelationalDatabase extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.STOP_RELATIONAL_DATABASE }
  case object EnableAddOn extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.ENABLE_ADD_ON }
  case object DisableAddOn extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DISABLE_ADD_ON }
  case object PutAlarm extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.PUT_ALARM }
  case object GetAlarms extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.GET_ALARMS }
  case object DeleteAlarm extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_ALARM }
  case object TestAlarm extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.TEST_ALARM }
  case object CreateContactMethod extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_CONTACT_METHOD }
  case object GetContactMethods extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.GET_CONTACT_METHODS }
  case object SendContactMethodVerification extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.SEND_CONTACT_METHOD_VERIFICATION }
  case object DeleteContactMethod extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_CONTACT_METHOD }
  case object CreateDistribution extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_DISTRIBUTION }
  case object UpdateDistribution extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.UPDATE_DISTRIBUTION }
  case object DeleteDistribution extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_DISTRIBUTION }
  case object ResetDistributionCache extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.RESET_DISTRIBUTION_CACHE }
  case object AttachCertificateToDistribution extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.ATTACH_CERTIFICATE_TO_DISTRIBUTION }
  case object DetachCertificateFromDistribution extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DETACH_CERTIFICATE_FROM_DISTRIBUTION }
  case object UpdateDistributionBundle extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.UPDATE_DISTRIBUTION_BUNDLE }
  case object SetIpAddressType extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.SET_IP_ADDRESS_TYPE }
  case object CreateCertificate extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_CERTIFICATE }
  case object DeleteCertificate extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_CERTIFICATE }
  case object CreateContainerService extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_CONTAINER_SERVICE }
  case object UpdateContainerService extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.UPDATE_CONTAINER_SERVICE }
  case object DeleteContainerService extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_CONTAINER_SERVICE }
  case object CreateContainerServiceDeployment extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_CONTAINER_SERVICE_DEPLOYMENT }
  case object CreateContainerServiceRegistryLogin extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.CREATE_CONTAINER_SERVICE_REGISTRY_LOGIN }
  case object RegisterContainerImage extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.REGISTER_CONTAINER_IMAGE }
  case object DeleteContainerImage extends OperationType { override def unwrap: software.amazon.awssdk.services.lightsail.model.OperationType = software.amazon.awssdk.services.lightsail.model.OperationType.DELETE_CONTAINER_IMAGE }
}