package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait LoadBalancerMetricName { def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName }
object LoadBalancerMetricName {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName): LoadBalancerMetricName = value match {
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.CLIENT_TLS_NEGOTIATION_ERROR_COUNT =>
      val r = ClientTLSNegotiationErrorCount
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.HEALTHY_HOST_COUNT =>
      val r = HealthyHostCount
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.UNHEALTHY_HOST_COUNT =>
      val r = UnhealthyHostCount
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.HTTP_CODE_LB_4_XX_COUNT =>
      val r = HTTPCode_LB_4XX_Count
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.HTTP_CODE_LB_5_XX_COUNT =>
      val r = HTTPCode_LB_5XX_Count
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.HTTP_CODE_INSTANCE_2_XX_COUNT =>
      val r = HTTPCode_Instance_2XX_Count
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.HTTP_CODE_INSTANCE_3_XX_COUNT =>
      val r = HTTPCode_Instance_3XX_Count
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.HTTP_CODE_INSTANCE_4_XX_COUNT =>
      val r = HTTPCode_Instance_4XX_Count
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.HTTP_CODE_INSTANCE_5_XX_COUNT =>
      val r = HTTPCode_Instance_5XX_Count
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.INSTANCE_RESPONSE_TIME =>
      val r = InstanceResponseTime
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.REJECTED_CONNECTION_COUNT =>
      val r = RejectedConnectionCount
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.REQUEST_COUNT =>
      val r = RequestCount
      r
  }
  case object unknownToSdkVersion extends LoadBalancerMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName = software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.UNKNOWN_TO_SDK_VERSION }
  case object ClientTLSNegotiationErrorCount extends LoadBalancerMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName = software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.CLIENT_TLS_NEGOTIATION_ERROR_COUNT }
  case object HealthyHostCount extends LoadBalancerMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName = software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.HEALTHY_HOST_COUNT }
  case object UnhealthyHostCount extends LoadBalancerMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName = software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.UNHEALTHY_HOST_COUNT }
  case object HTTPCode_LB_4XX_Count extends LoadBalancerMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName = software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.HTTP_CODE_LB_4_XX_COUNT }
  case object HTTPCode_LB_5XX_Count extends LoadBalancerMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName = software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.HTTP_CODE_LB_5_XX_COUNT }
  case object HTTPCode_Instance_2XX_Count extends LoadBalancerMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName = software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.HTTP_CODE_INSTANCE_2_XX_COUNT }
  case object HTTPCode_Instance_3XX_Count extends LoadBalancerMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName = software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.HTTP_CODE_INSTANCE_3_XX_COUNT }
  case object HTTPCode_Instance_4XX_Count extends LoadBalancerMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName = software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.HTTP_CODE_INSTANCE_4_XX_COUNT }
  case object HTTPCode_Instance_5XX_Count extends LoadBalancerMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName = software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.HTTP_CODE_INSTANCE_5_XX_COUNT }
  case object InstanceResponseTime extends LoadBalancerMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName = software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.INSTANCE_RESPONSE_TIME }
  case object RejectedConnectionCount extends LoadBalancerMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName = software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.REJECTED_CONNECTION_COUNT }
  case object RequestCount extends LoadBalancerMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName = software.amazon.awssdk.services.lightsail.model.LoadBalancerMetricName.REQUEST_COUNT }
}