package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait InstancePlatform { def unwrap: software.amazon.awssdk.services.lightsail.model.InstancePlatform }
object InstancePlatform {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.InstancePlatform): InstancePlatform = value match {
    case software.amazon.awssdk.services.lightsail.model.InstancePlatform.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.InstancePlatform.LINUX_UNIX =>
      val r = LINUX_UNIX
      r
    case software.amazon.awssdk.services.lightsail.model.InstancePlatform.WINDOWS =>
      val r = WINDOWS
      r
  }
  case object unknownToSdkVersion extends InstancePlatform { override def unwrap: software.amazon.awssdk.services.lightsail.model.InstancePlatform = software.amazon.awssdk.services.lightsail.model.InstancePlatform.UNKNOWN_TO_SDK_VERSION }
  case object LINUX_UNIX extends InstancePlatform { override def unwrap: software.amazon.awssdk.services.lightsail.model.InstancePlatform = software.amazon.awssdk.services.lightsail.model.InstancePlatform.LINUX_UNIX }
  case object WINDOWS extends InstancePlatform { override def unwrap: software.amazon.awssdk.services.lightsail.model.InstancePlatform = software.amazon.awssdk.services.lightsail.model.InstancePlatform.WINDOWS }
}