package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseMasterUserPasswordResponse(masterUserPassword: scala.Option[primitives.SensitiveString] = None, createdAt: scala.Option[primitives.IsoDate] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse = {
    import GetRelationalDatabaseMasterUserPasswordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.builder().optionallyWith(masterUserPassword.map(value => value: java.lang.String))(_.masterUserPassword).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).build()
  }
  def asReadOnly: GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly = GetRelationalDatabaseMasterUserPasswordResponse.wrap(buildAwsValue())
}
object GetRelationalDatabaseMasterUserPasswordResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseMasterUserPasswordResponse = GetRelationalDatabaseMasterUserPasswordResponse(masterUserPasswordValue.map(value => value), createdAtValue.map(value => value))
    def masterUserPasswordValue: scala.Option[primitives.SensitiveString]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def masterUserPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SensitiveString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse) extends GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly {
    override def masterUserPasswordValue: scala.Option[primitives.SensitiveString] = scala.Option(impl.masterUserPassword()).map(value => value: primitives.SensitiveString)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse): ReadOnly = new Wrapper(impl)
}