package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetLoadBalancerResponse(loadBalancer: scala.Option[LoadBalancer] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse = {
    import GetLoadBalancerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse.builder().optionallyWith(loadBalancer.map(value => value.buildAwsValue()))(_.loadBalancer).build()
  }
  def asReadOnly: GetLoadBalancerResponse.ReadOnly = GetLoadBalancerResponse.wrap(buildAwsValue())
}
object GetLoadBalancerResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetLoadBalancerResponse = GetLoadBalancerResponse(loadBalancerValue.map(value => value.editable))
    def loadBalancerValue: scala.Option[LoadBalancer.ReadOnly]
    def loadBalancer: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LoadBalancer.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loadBalancer", loadBalancerValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse) extends GetLoadBalancerResponse.ReadOnly { override def loadBalancerValue: scala.Option[LoadBalancer.ReadOnly] = scala.Option(impl.loadBalancer()).map(value => LoadBalancer.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse): ReadOnly = new Wrapper(impl)
}