package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetInstanceStateResponse(state: scala.Option[InstanceState] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse = {
    import GetInstanceStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse.builder().optionallyWith(state.map(value => value.buildAwsValue()))(_.state).build()
  }
  def asReadOnly: GetInstanceStateResponse.ReadOnly = GetInstanceStateResponse.wrap(buildAwsValue())
}
object GetInstanceStateResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetInstanceStateResponse = GetInstanceStateResponse(stateValue.map(value => value.editable))
    def stateValue: scala.Option[InstanceState.ReadOnly]
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstanceState.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse) extends GetInstanceStateResponse.ReadOnly { override def stateValue: scala.Option[InstanceState.ReadOnly] = scala.Option(impl.state()).map(value => InstanceState.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse): ReadOnly = new Wrapper(impl)
}