package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DetachDiskRequest(diskName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DetachDiskRequest = {
    import DetachDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DetachDiskRequest.builder().diskName(diskName: java.lang.String).build()
  }
  def asReadOnly: DetachDiskRequest.ReadOnly = DetachDiskRequest.wrap(buildAwsValue())
}
object DetachDiskRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DetachDiskRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DetachDiskRequest = DetachDiskRequest(diskNameValue)
    def diskNameValue: primitives.ResourceName
    def diskName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(diskNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DetachDiskRequest) extends DetachDiskRequest.ReadOnly { override def diskNameValue: primitives.ResourceName = impl.diskName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DetachDiskRequest): ReadOnly = new Wrapper(impl)
}