package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteDomainRequest(domainName: primitives.DomainName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest = {
    import DeleteDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest.builder().domainName(domainName: java.lang.String).build()
  }
  def asReadOnly: DeleteDomainRequest.ReadOnly = DeleteDomainRequest.wrap(buildAwsValue())
}
object DeleteDomainRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteDomainRequest = DeleteDomainRequest(domainNameValue)
    def domainNameValue: primitives.DomainName
    def domainName: ZIO[Any, Nothing, primitives.DomainName] = ZIO.succeed(domainNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest) extends DeleteDomainRequest.ReadOnly { override def domainNameValue: primitives.DomainName = impl.domainName(): primitives.DomainName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest): ReadOnly = new Wrapper(impl)
}