package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseResponse.ReadOnly
import software.amazon.awssdk.services.licensemanager.{
  LicenseManagerAsyncClientBuilder,
  LicenseManagerAsyncClient
}
import io.github.vigoo.zioaws.licensemanager.model.{
  CreateLicenseManagerReportGeneratorRequest,
  GetServiceSettingsRequest,
  UpdateLicenseConfigurationRequest,
  CheckoutBorrowLicenseRequest,
  DeleteLicenseRequest,
  DeleteGrantRequest,
  ListResourceInventoryRequest,
  GetGrantRequest,
  ListDistributedGrantsRequest,
  CheckInLicenseRequest,
  GetAccessTokenRequest,
  ListAssociationsForLicenseConfigurationRequest,
  GetLicenseUsageRequest,
  ListLicenseSpecificationsForResourceRequest,
  GetLicenseConversionTaskRequest,
  RejectGrantRequest,
  DeleteLicenseManagerReportGeneratorRequest,
  GetLicenseConfigurationRequest,
  ListLicenseConfigurationsRequest,
  ExtendLicenseConsumptionRequest,
  ListTagsForResourceRequest,
  DeleteTokenRequest,
  ListLicenseConversionTasksRequest,
  DeleteLicenseConfigurationRequest,
  CreateLicenseConfigurationRequest,
  AcceptGrantRequest,
  ListLicenseVersionsRequest,
  ListReceivedLicensesRequest,
  CreateLicenseConversionTaskForResourceRequest,
  CheckoutLicenseRequest,
  CreateGrantRequest,
  ListUsageForLicenseConfigurationRequest,
  CreateTokenRequest,
  UpdateLicenseSpecificationsForResourceRequest,
  ListLicenseManagerReportGeneratorsRequest,
  UntagResourceRequest,
  ListLicensesRequest,
  GetLicenseManagerReportGeneratorRequest,
  ListTokensRequest,
  ListFailuresForLicenseConfigurationOperationsRequest,
  UpdateServiceSettingsRequest,
  ListReceivedGrantsRequest,
  UpdateLicenseManagerReportGeneratorRequest,
  CreateGrantVersionRequest,
  GetLicenseRequest,
  TagResourceRequest,
  CreateLicenseVersionRequest,
  CreateLicenseRequest
}
import io.github.vigoo.zioaws.core.{AwsServiceBase, AwsError}
import io.github.vigoo.zioaws.licensemanager.LicenseManager
import io.github.vigoo.zioaws.core.config.AwsConfig
import zio.{ZManaged, IO, ZIO, ZLayer, URLayer, Has}
import io.github.vigoo.zioaws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.stream.ZStream
import software.amazon.awssdk.services.licensemanager.model.{
  GetLicenseConfigurationResponse,
  ListLicenseConversionTasksResponse,
  ListFailuresForLicenseConfigurationOperationsResponse,
  DeleteTokenResponse,
  CreateLicenseConversionTaskForResourceResponse,
  LicenseConversionTask,
  DeleteGrantResponse,
  GetAccessTokenResponse,
  ListUsageForLicenseConfigurationResponse,
  ListLicensesResponse,
  LicenseConfigurationUsage,
  GetLicenseConversionTaskResponse,
  UpdateLicenseSpecificationsForResourceResponse,
  ListLicenseVersionsResponse,
  ReportGenerator,
  ListResourceInventoryResponse,
  CreateGrantVersionResponse,
  Grant,
  AcceptGrantResponse,
  CheckInLicenseResponse,
  GetLicenseManagerReportGeneratorResponse,
  ExtendLicenseConsumptionResponse,
  CheckoutLicenseResponse,
  DeleteLicenseResponse,
  GrantedLicense,
  ListLicenseManagerReportGeneratorsResponse,
  ListTagsForResourceResponse,
  TokenData,
  CreateLicenseManagerReportGeneratorResponse,
  UpdateLicenseConfigurationResponse,
  UntagResourceResponse,
  ListTokensResponse,
  UpdateLicenseManagerReportGeneratorResponse,
  GetGrantResponse,
  LicenseOperationFailure,
  LicenseSpecification,
  GetLicenseResponse,
  ListLicenseSpecificationsForResourceResponse,
  DeleteLicenseManagerReportGeneratorResponse,
  CheckoutBorrowLicenseResponse,
  CreateGrantResponse,
  UpdateServiceSettingsResponse,
  ListAssociationsForLicenseConfigurationResponse,
  GetLicenseUsageResponse,
  ResourceInventory,
  ListDistributedGrantsResponse,
  License,
  CreateLicenseVersionResponse,
  CreateLicenseResponse,
  LicenseConfiguration,
  CreateLicenseConfigurationResponse,
  ListReceivedLicensesResponse,
  TagResourceResponse,
  GetServiceSettingsResponse,
  LicenseConfigurationAssociation,
  DeleteLicenseConfigurationResponse,
  CreateTokenResponse,
  RejectGrantResponse,
  ListLicenseConfigurationsResponse,
  ListReceivedGrantsResponse
}
import zio.test.mock.{Proxy, Mock}
package object licensemanager {
  import scala.jdk.CollectionConverters.*
  type LicenseManager = Has[LicenseManager.Service]
  object LicenseManager {
    trait Service extends AspectSupport[Service] {
      val api: LicenseManagerAsyncClient
      def checkoutLicense(request: CheckoutLicenseRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseResponse.ReadOnly
      ]
      def listLicenseManagerReportGenerators(
          request: ListLicenseManagerReportGeneratorsRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.ReadOnly
      ]
      def getServiceSettings(request: GetServiceSettingsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.GetServiceSettingsResponse.ReadOnly
      ]
      def createToken(request: CreateTokenRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.CreateTokenResponse.ReadOnly
      ]
      def createLicense(request: CreateLicenseRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.CreateLicenseResponse.ReadOnly
      ]
      def deleteLicenseConfiguration(
          request: DeleteLicenseConfigurationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseConfigurationResponse.ReadOnly
      ]
      def createGrant(request: CreateGrantRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.CreateGrantResponse.ReadOnly
      ]
      def checkoutBorrowLicense(request: CheckoutBorrowLicenseRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseResponse.ReadOnly
      ]
      def createGrantVersion(request: CreateGrantVersionRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionResponse.ReadOnly
      ]
      def getGrant(request: GetGrantRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.GetGrantResponse.ReadOnly
      ]
      def getLicenseConversionTask(
          request: GetLicenseConversionTaskRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.GetLicenseConversionTaskResponse.ReadOnly
      ]
      def deleteToken(request: DeleteTokenRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.DeleteTokenResponse.ReadOnly
      ]
      def listResourceInventory(request: ListResourceInventoryRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.ResourceInventory.ReadOnly
      ]
      def getAccessToken(request: GetAccessTokenRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenResponse.ReadOnly
      ]
      def listLicenses(request: ListLicensesRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly
      ]
      def updateLicenseConfiguration(
          request: UpdateLicenseConfigurationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseConfigurationResponse.ReadOnly
      ]
      def createLicenseConversionTaskForResource(
          request: CreateLicenseConversionTaskForResourceRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceResponse.ReadOnly
      ]
      def createLicenseVersion(request: CreateLicenseVersionRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionResponse.ReadOnly
      ]
      def createLicenseManagerReportGenerator(
          request: CreateLicenseManagerReportGeneratorRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.CreateLicenseManagerReportGeneratorResponse.ReadOnly
      ]
      def listLicenseSpecificationsForResource(
          request: ListLicenseSpecificationsForResourceRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly
      ]
      def deleteGrant(request: DeleteGrantRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.DeleteGrantResponse.ReadOnly
      ]
      def listLicenseConversionTasks(
          request: ListLicenseConversionTasksRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask.ReadOnly
      ]
      def rejectGrant(request: RejectGrantRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.RejectGrantResponse.ReadOnly
      ]
      def checkInLicense(request: CheckInLicenseRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.CheckInLicenseResponse.ReadOnly
      ]
      def updateServiceSettings(request: UpdateServiceSettingsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.UpdateServiceSettingsResponse.ReadOnly
      ]
      def getLicenseConfiguration(request: GetLicenseConfigurationRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.GetLicenseConfigurationResponse.ReadOnly
      ]
      def untagResource(request: UntagResourceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.UntagResourceResponse.ReadOnly
      ]
      def listAssociationsForLicenseConfiguration(
          request: ListAssociationsForLicenseConfigurationRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation.ReadOnly
      ]
      def deleteLicenseManagerReportGenerator(
          request: DeleteLicenseManagerReportGeneratorRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseManagerReportGeneratorResponse.ReadOnly
      ]
      def acceptGrant(request: AcceptGrantRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.AcceptGrantResponse.ReadOnly
      ]
      def updateLicenseSpecificationsForResource(
          request: UpdateLicenseSpecificationsForResourceRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseSpecificationsForResourceResponse.ReadOnly
      ]
      def updateLicenseManagerReportGenerator(
          request: UpdateLicenseManagerReportGeneratorRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseManagerReportGeneratorResponse.ReadOnly
      ]
      def deleteLicense(request: DeleteLicenseRequest): IO[AwsError, ReadOnly]
      def extendLicenseConsumption(
          request: ExtendLicenseConsumptionRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionResponse.ReadOnly
      ]
      def listLicenseConfigurations(
          request: ListLicenseConfigurationsRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.LicenseConfiguration.ReadOnly
      ]
      def listTokens(request: ListTokensRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.TokenData.ReadOnly
      ]
      def listDistributedGrants(request: ListDistributedGrantsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly
      ]
      def listTagsForResource(request: ListTagsForResourceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.ListTagsForResourceResponse.ReadOnly
      ]
      def tagResource(request: TagResourceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.TagResourceResponse.ReadOnly
      ]
      def listLicenseVersions(request: ListLicenseVersionsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly
      ]
      def getLicenseUsage(request: GetLicenseUsageRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.GetLicenseUsageResponse.ReadOnly
      ]
      def getLicense(request: GetLicenseRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.GetLicenseResponse.ReadOnly
      ]
      def createLicenseConfiguration(
          request: CreateLicenseConfigurationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationResponse.ReadOnly
      ]
      def listReceivedLicenses(request: ListReceivedLicensesRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.GrantedLicense.ReadOnly
      ]
      def listReceivedGrants(request: ListReceivedGrantsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly
      ]
      def listUsageForLicenseConfiguration(
          request: ListUsageForLicenseConfigurationRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage.ReadOnly
      ]
      def listFailuresForLicenseConfigurationOperations(
          request: ListFailuresForLicenseConfigurationOperationsRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure.ReadOnly
      ]
      def getLicenseManagerReportGenerator(
          request: GetLicenseManagerReportGeneratorRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorResponse.ReadOnly
      ]
    }
    object LicenseManagerMock extends Mock[LicenseManager] {
      object CheckoutLicense
          extends Effect[
            CheckoutLicenseRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseResponse.ReadOnly
          ]
      object ListLicenseManagerReportGenerators
          extends Stream[
            ListLicenseManagerReportGeneratorsRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.ReadOnly
          ]
      object GetServiceSettings
          extends Effect[
            GetServiceSettingsRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.GetServiceSettingsResponse.ReadOnly
          ]
      object CreateToken
          extends Effect[
            CreateTokenRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.CreateTokenResponse.ReadOnly
          ]
      object CreateLicense
          extends Effect[
            CreateLicenseRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.CreateLicenseResponse.ReadOnly
          ]
      object DeleteLicenseConfiguration
          extends Effect[
            DeleteLicenseConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseConfigurationResponse.ReadOnly
          ]
      object CreateGrant
          extends Effect[
            CreateGrantRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.CreateGrantResponse.ReadOnly
          ]
      object CheckoutBorrowLicense
          extends Effect[
            CheckoutBorrowLicenseRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseResponse.ReadOnly
          ]
      object CreateGrantVersion
          extends Effect[
            CreateGrantVersionRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionResponse.ReadOnly
          ]
      object GetGrant
          extends Effect[
            GetGrantRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.GetGrantResponse.ReadOnly
          ]
      object GetLicenseConversionTask
          extends Effect[
            GetLicenseConversionTaskRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.GetLicenseConversionTaskResponse.ReadOnly
          ]
      object DeleteToken
          extends Effect[
            DeleteTokenRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.DeleteTokenResponse.ReadOnly
          ]
      object ListResourceInventory
          extends Stream[
            ListResourceInventoryRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.ResourceInventory.ReadOnly
          ]
      object GetAccessToken
          extends Effect[
            GetAccessTokenRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenResponse.ReadOnly
          ]
      object ListLicenses
          extends Stream[
            ListLicensesRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly
          ]
      object UpdateLicenseConfiguration
          extends Effect[
            UpdateLicenseConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseConfigurationResponse.ReadOnly
          ]
      object CreateLicenseConversionTaskForResource
          extends Effect[
            CreateLicenseConversionTaskForResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceResponse.ReadOnly
          ]
      object CreateLicenseVersion
          extends Effect[
            CreateLicenseVersionRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionResponse.ReadOnly
          ]
      object CreateLicenseManagerReportGenerator
          extends Effect[
            CreateLicenseManagerReportGeneratorRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.CreateLicenseManagerReportGeneratorResponse.ReadOnly
          ]
      object ListLicenseSpecificationsForResource
          extends Stream[
            ListLicenseSpecificationsForResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly
          ]
      object DeleteGrant
          extends Effect[
            DeleteGrantRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.DeleteGrantResponse.ReadOnly
          ]
      object ListLicenseConversionTasks
          extends Stream[
            ListLicenseConversionTasksRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask.ReadOnly
          ]
      object RejectGrant
          extends Effect[
            RejectGrantRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.RejectGrantResponse.ReadOnly
          ]
      object CheckInLicense
          extends Effect[
            CheckInLicenseRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.CheckInLicenseResponse.ReadOnly
          ]
      object UpdateServiceSettings
          extends Effect[
            UpdateServiceSettingsRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.UpdateServiceSettingsResponse.ReadOnly
          ]
      object GetLicenseConfiguration
          extends Effect[
            GetLicenseConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.GetLicenseConfigurationResponse.ReadOnly
          ]
      object UntagResource
          extends Effect[
            UntagResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.UntagResourceResponse.ReadOnly
          ]
      object ListAssociationsForLicenseConfiguration
          extends Stream[
            ListAssociationsForLicenseConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation.ReadOnly
          ]
      object DeleteLicenseManagerReportGenerator
          extends Effect[
            DeleteLicenseManagerReportGeneratorRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseManagerReportGeneratorResponse.ReadOnly
          ]
      object AcceptGrant
          extends Effect[
            AcceptGrantRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.AcceptGrantResponse.ReadOnly
          ]
      object UpdateLicenseSpecificationsForResource
          extends Effect[
            UpdateLicenseSpecificationsForResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseSpecificationsForResourceResponse.ReadOnly
          ]
      object UpdateLicenseManagerReportGenerator
          extends Effect[
            UpdateLicenseManagerReportGeneratorRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseManagerReportGeneratorResponse.ReadOnly
          ]
      object DeleteLicense
          extends Effect[DeleteLicenseRequest, AwsError, ReadOnly]
      object ExtendLicenseConsumption
          extends Effect[
            ExtendLicenseConsumptionRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionResponse.ReadOnly
          ]
      object ListLicenseConfigurations
          extends Stream[
            ListLicenseConfigurationsRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.LicenseConfiguration.ReadOnly
          ]
      object ListTokens
          extends Stream[
            ListTokensRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.TokenData.ReadOnly
          ]
      object ListDistributedGrants
          extends Stream[
            ListDistributedGrantsRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly
          ]
      object ListTagsForResource
          extends Effect[
            ListTagsForResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.ListTagsForResourceResponse.ReadOnly
          ]
      object TagResource
          extends Effect[
            TagResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.TagResourceResponse.ReadOnly
          ]
      object ListLicenseVersions
          extends Stream[
            ListLicenseVersionsRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly
          ]
      object GetLicenseUsage
          extends Effect[
            GetLicenseUsageRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.GetLicenseUsageResponse.ReadOnly
          ]
      object GetLicense
          extends Effect[
            GetLicenseRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.GetLicenseResponse.ReadOnly
          ]
      object CreateLicenseConfiguration
          extends Effect[
            CreateLicenseConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationResponse.ReadOnly
          ]
      object ListReceivedLicenses
          extends Stream[
            ListReceivedLicensesRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.GrantedLicense.ReadOnly
          ]
      object ListReceivedGrants
          extends Stream[
            ListReceivedGrantsRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly
          ]
      object ListUsageForLicenseConfiguration
          extends Stream[
            ListUsageForLicenseConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage.ReadOnly
          ]
      object ListFailuresForLicenseConfigurationOperations
          extends Stream[
            ListFailuresForLicenseConfigurationOperationsRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure.ReadOnly
          ]
      object GetLicenseManagerReportGenerator
          extends Effect[
            GetLicenseManagerReportGeneratorRequest,
            AwsError,
            io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorResponse.ReadOnly
          ]
      val compose: URLayer[Has[Proxy], LicenseManager] = ZLayer.fromServiceM {
        proxy =>
          withRuntime.map { rts =>
            new LicenseManager.Service {
              val api: LicenseManagerAsyncClient = null
              def withAspect[R1](
                  newAspect: AwsCallAspect[R1],
                  r: R1
              ): LicenseManager.Service = this
              def checkoutLicense(request: CheckoutLicenseRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseResponse.ReadOnly
              ] = proxy(CheckoutLicense, request)
              def listLicenseManagerReportGenerators(
                  request: ListLicenseManagerReportGeneratorsRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.ReadOnly
              ] = rts.unsafeRun(
                proxy(ListLicenseManagerReportGenerators, request)
              )
              def getServiceSettings(request: GetServiceSettingsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.GetServiceSettingsResponse.ReadOnly
              ] = proxy(GetServiceSettings, request)
              def createToken(request: CreateTokenRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.CreateTokenResponse.ReadOnly
              ] = proxy(CreateToken, request)
              def createLicense(request: CreateLicenseRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.CreateLicenseResponse.ReadOnly
              ] = proxy(CreateLicense, request)
              def deleteLicenseConfiguration(
                  request: DeleteLicenseConfigurationRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseConfigurationResponse.ReadOnly
              ] = proxy(DeleteLicenseConfiguration, request)
              def createGrant(request: CreateGrantRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.CreateGrantResponse.ReadOnly
              ] = proxy(CreateGrant, request)
              def checkoutBorrowLicense(
                  request: CheckoutBorrowLicenseRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseResponse.ReadOnly
              ] = proxy(CheckoutBorrowLicense, request)
              def createGrantVersion(request: CreateGrantVersionRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionResponse.ReadOnly
              ] = proxy(CreateGrantVersion, request)
              def getGrant(request: GetGrantRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.GetGrantResponse.ReadOnly
              ] = proxy(GetGrant, request)
              def getLicenseConversionTask(
                  request: GetLicenseConversionTaskRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.GetLicenseConversionTaskResponse.ReadOnly
              ] = proxy(GetLicenseConversionTask, request)
              def deleteToken(request: DeleteTokenRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.DeleteTokenResponse.ReadOnly
              ] = proxy(DeleteToken, request)
              def listResourceInventory(
                  request: ListResourceInventoryRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.ResourceInventory.ReadOnly
              ] = rts.unsafeRun(proxy(ListResourceInventory, request))
              def getAccessToken(request: GetAccessTokenRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenResponse.ReadOnly
              ] = proxy(GetAccessToken, request)
              def listLicenses(request: ListLicensesRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly
              ] = rts.unsafeRun(proxy(ListLicenses, request))
              def updateLicenseConfiguration(
                  request: UpdateLicenseConfigurationRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseConfigurationResponse.ReadOnly
              ] = proxy(UpdateLicenseConfiguration, request)
              def createLicenseConversionTaskForResource(
                  request: CreateLicenseConversionTaskForResourceRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceResponse.ReadOnly
              ] = proxy(CreateLicenseConversionTaskForResource, request)
              def createLicenseVersion(
                  request: CreateLicenseVersionRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionResponse.ReadOnly
              ] = proxy(CreateLicenseVersion, request)
              def createLicenseManagerReportGenerator(
                  request: CreateLicenseManagerReportGeneratorRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.CreateLicenseManagerReportGeneratorResponse.ReadOnly
              ] = proxy(CreateLicenseManagerReportGenerator, request)
              def listLicenseSpecificationsForResource(
                  request: ListLicenseSpecificationsForResourceRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly
              ] = rts.unsafeRun(
                proxy(ListLicenseSpecificationsForResource, request)
              )
              def deleteGrant(request: DeleteGrantRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.DeleteGrantResponse.ReadOnly
              ] = proxy(DeleteGrant, request)
              def listLicenseConversionTasks(
                  request: ListLicenseConversionTasksRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask.ReadOnly
              ] = rts.unsafeRun(proxy(ListLicenseConversionTasks, request))
              def rejectGrant(request: RejectGrantRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.RejectGrantResponse.ReadOnly
              ] = proxy(RejectGrant, request)
              def checkInLicense(request: CheckInLicenseRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.CheckInLicenseResponse.ReadOnly
              ] = proxy(CheckInLicense, request)
              def updateServiceSettings(
                  request: UpdateServiceSettingsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.UpdateServiceSettingsResponse.ReadOnly
              ] = proxy(UpdateServiceSettings, request)
              def getLicenseConfiguration(
                  request: GetLicenseConfigurationRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.GetLicenseConfigurationResponse.ReadOnly
              ] = proxy(GetLicenseConfiguration, request)
              def untagResource(request: UntagResourceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.UntagResourceResponse.ReadOnly
              ] = proxy(UntagResource, request)
              def listAssociationsForLicenseConfiguration(
                  request: ListAssociationsForLicenseConfigurationRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation.ReadOnly
              ] = rts.unsafeRun(
                proxy(ListAssociationsForLicenseConfiguration, request)
              )
              def deleteLicenseManagerReportGenerator(
                  request: DeleteLicenseManagerReportGeneratorRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseManagerReportGeneratorResponse.ReadOnly
              ] = proxy(DeleteLicenseManagerReportGenerator, request)
              def acceptGrant(request: AcceptGrantRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.AcceptGrantResponse.ReadOnly
              ] = proxy(AcceptGrant, request)
              def updateLicenseSpecificationsForResource(
                  request: UpdateLicenseSpecificationsForResourceRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseSpecificationsForResourceResponse.ReadOnly
              ] = proxy(UpdateLicenseSpecificationsForResource, request)
              def updateLicenseManagerReportGenerator(
                  request: UpdateLicenseManagerReportGeneratorRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseManagerReportGeneratorResponse.ReadOnly
              ] = proxy(UpdateLicenseManagerReportGenerator, request)
              def deleteLicense(
                  request: DeleteLicenseRequest
              ): IO[AwsError, ReadOnly] = proxy(DeleteLicense, request)
              def extendLicenseConsumption(
                  request: ExtendLicenseConsumptionRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionResponse.ReadOnly
              ] = proxy(ExtendLicenseConsumption, request)
              def listLicenseConfigurations(
                  request: ListLicenseConfigurationsRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.LicenseConfiguration.ReadOnly
              ] = rts.unsafeRun(proxy(ListLicenseConfigurations, request))
              def listTokens(request: ListTokensRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.TokenData.ReadOnly
              ] = rts.unsafeRun(proxy(ListTokens, request))
              def listDistributedGrants(
                  request: ListDistributedGrantsRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly
              ] = rts.unsafeRun(proxy(ListDistributedGrants, request))
              def listTagsForResource(request: ListTagsForResourceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.ListTagsForResourceResponse.ReadOnly
              ] = proxy(ListTagsForResource, request)
              def tagResource(request: TagResourceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.TagResourceResponse.ReadOnly
              ] = proxy(TagResource, request)
              def listLicenseVersions(
                  request: ListLicenseVersionsRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly
              ] = rts.unsafeRun(proxy(ListLicenseVersions, request))
              def getLicenseUsage(request: GetLicenseUsageRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.GetLicenseUsageResponse.ReadOnly
              ] = proxy(GetLicenseUsage, request)
              def getLicense(request: GetLicenseRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.GetLicenseResponse.ReadOnly
              ] = proxy(GetLicense, request)
              def createLicenseConfiguration(
                  request: CreateLicenseConfigurationRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationResponse.ReadOnly
              ] = proxy(CreateLicenseConfiguration, request)
              def listReceivedLicenses(
                  request: ListReceivedLicensesRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.GrantedLicense.ReadOnly
              ] = rts.unsafeRun(proxy(ListReceivedLicenses, request))
              def listReceivedGrants(
                  request: ListReceivedGrantsRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly
              ] = rts.unsafeRun(proxy(ListReceivedGrants, request))
              def listUsageForLicenseConfiguration(
                  request: ListUsageForLicenseConfigurationRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage.ReadOnly
              ] =
                rts.unsafeRun(proxy(ListUsageForLicenseConfiguration, request))
              def listFailuresForLicenseConfigurationOperations(
                  request: ListFailuresForLicenseConfigurationOperationsRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure.ReadOnly
              ] = rts.unsafeRun(
                proxy(ListFailuresForLicenseConfigurationOperations, request)
              )
              def getLicenseManagerReportGenerator(
                  request: GetLicenseManagerReportGeneratorRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorResponse.ReadOnly
              ] = proxy(GetLicenseManagerReportGenerator, request)
            }
          }
      }
    }
  }
  val live: ZLayer[AwsConfig, java.lang.Throwable, LicenseManager] = customized(
    identity
  )
  def customized(
      customization: LicenseManagerAsyncClientBuilder => LicenseManagerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, LicenseManager] = managed(
    customization
  ).toLayer
  def managed(
      customization: LicenseManagerAsyncClientBuilder => LicenseManagerAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, LicenseManager.Service] = for (
    awsConfig <- ZManaged.service[AwsConfig.Service];
    executor <- ZIO.executor.toManaged_;
    builder = LicenseManagerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[LicenseManagerAsyncClient, LicenseManagerAsyncClientBuilder](
        builder
      )
      .toManaged_;
    b1 <- awsConfig
      .configureHttpClient[
        LicenseManagerAsyncClient,
        LicenseManagerAsyncClientBuilder
      ](
        b0,
        io.github.vigoo.zioaws.core.httpclient
          .ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged_; client <- zio.ZIO(customization(b1).build()).toManaged_
  )
    yield new LicenseManagerImpl(
      client,
      AwsCallAspect.identity,
      ().asInstanceOf[Any]
    )
  private class LicenseManagerImpl[R](
      override val api: LicenseManagerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: R
  ) extends LicenseManager.Service
      with AwsServiceBase[R, LicenseManagerImpl] {
    override val serviceName: String = "LicenseManager"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: R1
    ): LicenseManagerImpl[R1] = new LicenseManagerImpl(api, newAspect, r)
    def checkoutLicense(request: CheckoutLicenseRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest,
      CheckoutLicenseResponse
    ]("checkoutLicense", api.checkoutLicense)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseResponse.wrap
      )
      .provide(r)
    def listLicenseManagerReportGenerators(
        request: ListLicenseManagerReportGeneratorsRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsRequest,
      ListLicenseManagerReportGeneratorsResponse,
      ReportGenerator
    ](
      "listLicenseManagerReportGenerators",
      api.listLicenseManagerReportGenerators,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.reportGenerators().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.wrap(item)
      )
      .provide(r)
    def getServiceSettings(request: GetServiceSettingsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.GetServiceSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsRequest,
      GetServiceSettingsResponse
    ]("getServiceSettings", api.getServiceSettings)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.GetServiceSettingsResponse.wrap
      )
      .provide(r)
    def createToken(request: CreateTokenRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.CreateTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest,
      CreateTokenResponse
    ]("createToken", api.createToken)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.licensemanager.model.CreateTokenResponse.wrap)
      .provide(r)
    def createLicense(request: CreateLicenseRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.CreateLicenseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest,
      CreateLicenseResponse
    ]("createLicense", api.createLicense)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.CreateLicenseResponse.wrap
      )
      .provide(r)
    def deleteLicenseConfiguration(
        request: DeleteLicenseConfigurationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest,
      DeleteLicenseConfigurationResponse
    ]("deleteLicenseConfiguration", api.deleteLicenseConfiguration)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseConfigurationResponse.wrap
    ).provide(r)
    def createGrant(request: CreateGrantRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.CreateGrantResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest,
      CreateGrantResponse
    ]("createGrant", api.createGrant)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.licensemanager.model.CreateGrantResponse.wrap)
      .provide(r)
    def checkoutBorrowLicense(request: CheckoutBorrowLicenseRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest,
      CheckoutBorrowLicenseResponse
    ]("checkoutBorrowLicense", api.checkoutBorrowLicense)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseResponse.wrap
    ).provide(r)
    def createGrantVersion(request: CreateGrantVersionRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest,
      CreateGrantVersionResponse
    ]("createGrantVersion", api.createGrantVersion)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionResponse.wrap
      )
      .provide(r)
    def getGrant(request: GetGrantRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.GetGrantResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.GetGrantRequest,
      GetGrantResponse
    ]("getGrant", api.getGrant)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.licensemanager.model.GetGrantResponse.wrap)
      .provide(r)
    def getLicenseConversionTask(request: GetLicenseConversionTaskRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.GetLicenseConversionTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.GetLicenseConversionTaskRequest,
      GetLicenseConversionTaskResponse
    ]("getLicenseConversionTask", api.getLicenseConversionTask)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.licensemanager.model.GetLicenseConversionTaskResponse.wrap
    ).provide(r)
    def deleteToken(request: DeleteTokenRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.DeleteTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.DeleteTokenRequest,
      DeleteTokenResponse
    ]("deleteToken", api.deleteToken)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.licensemanager.model.DeleteTokenResponse.wrap)
      .provide(r)
    def listResourceInventory(request: ListResourceInventoryRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ResourceInventory.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest,
      ListResourceInventoryResponse,
      ResourceInventory
    ](
      "listResourceInventory",
      api.listResourceInventory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resourceInventoryList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.licensemanager.model.ResourceInventory.wrap(item)
      )
      .provide(r)
    def getAccessToken(request: GetAccessTokenRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest,
      GetAccessTokenResponse
    ]("getAccessToken", api.getAccessToken)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenResponse.wrap
      )
      .provide(r)
    def listLicenses(request: ListLicensesRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanager.model.ListLicensesRequest,
      ListLicensesResponse,
      License
    ](
      "listLicenses",
      api.listLicenses,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.licenses().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.licensemanager.model.License.wrap(item)
      )
      .provide(r)
    def updateLicenseConfiguration(
        request: UpdateLicenseConfigurationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest,
      UpdateLicenseConfigurationResponse
    ]("updateLicenseConfiguration", api.updateLicenseConfiguration)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseConfigurationResponse.wrap
    ).provide(r)
    def createLicenseConversionTaskForResource(
        request: CreateLicenseConversionTaskForResourceRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceRequest,
      CreateLicenseConversionTaskForResourceResponse
    ](
      "createLicenseConversionTaskForResource",
      api.createLicenseConversionTaskForResource
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceResponse.wrap
      )
      .provide(r)
    def createLicenseVersion(request: CreateLicenseVersionRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest,
      CreateLicenseVersionResponse
    ]("createLicenseVersion", api.createLicenseVersion)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionResponse.wrap
      )
      .provide(r)
    def createLicenseManagerReportGenerator(
        request: CreateLicenseManagerReportGeneratorRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.CreateLicenseManagerReportGeneratorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorRequest,
      CreateLicenseManagerReportGeneratorResponse
    ](
      "createLicenseManagerReportGenerator",
      api.createLicenseManagerReportGenerator
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.CreateLicenseManagerReportGeneratorResponse.wrap
      )
      .provide(r)
    def listLicenseSpecificationsForResource(
        request: ListLicenseSpecificationsForResourceRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest,
      ListLicenseSpecificationsForResourceResponse,
      LicenseSpecification
    ](
      "listLicenseSpecificationsForResource",
      api.listLicenseSpecificationsForResource,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.licenseSpecifications().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification
          .wrap(item)
      )
      .provide(r)
    def deleteGrant(request: DeleteGrantRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.DeleteGrantResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest,
      DeleteGrantResponse
    ]("deleteGrant", api.deleteGrant)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.licensemanager.model.DeleteGrantResponse.wrap)
      .provide(r)
    def listLicenseConversionTasks(
        request: ListLicenseConversionTasksRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksRequest,
      ListLicenseConversionTasksResponse,
      LicenseConversionTask
    ](
      "listLicenseConversionTasks",
      api.listLicenseConversionTasks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.licenseConversionTasks().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask
          .wrap(item)
      )
      .provide(r)
    def rejectGrant(request: RejectGrantRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.RejectGrantResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.RejectGrantRequest,
      RejectGrantResponse
    ]("rejectGrant", api.rejectGrant)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.licensemanager.model.RejectGrantResponse.wrap)
      .provide(r)
    def checkInLicense(request: CheckInLicenseRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.CheckInLicenseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest,
      CheckInLicenseResponse
    ]("checkInLicense", api.checkInLicense)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.CheckInLicenseResponse.wrap
      )
      .provide(r)
    def updateServiceSettings(request: UpdateServiceSettingsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.UpdateServiceSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest,
      UpdateServiceSettingsResponse
    ]("updateServiceSettings", api.updateServiceSettings)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.licensemanager.model.UpdateServiceSettingsResponse.wrap
    ).provide(r)
    def getLicenseConfiguration(request: GetLicenseConfigurationRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.GetLicenseConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationRequest,
      GetLicenseConfigurationResponse
    ]("getLicenseConfiguration", api.getLicenseConfiguration)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.licensemanager.model.GetLicenseConfigurationResponse.wrap
    ).provide(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.UntagResourceResponse.wrap
      )
      .provide(r)
    def listAssociationsForLicenseConfiguration(
        request: ListAssociationsForLicenseConfigurationRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationRequest,
      ListAssociationsForLicenseConfigurationResponse,
      LicenseConfigurationAssociation
    ](
      "listAssociationsForLicenseConfiguration",
      api.listAssociationsForLicenseConfiguration,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.licenseConfigurationAssociations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation
          .wrap(item)
      )
      .provide(r)
    def deleteLicenseManagerReportGenerator(
        request: DeleteLicenseManagerReportGeneratorRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseManagerReportGeneratorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest,
      DeleteLicenseManagerReportGeneratorResponse
    ](
      "deleteLicenseManagerReportGenerator",
      api.deleteLicenseManagerReportGenerator
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseManagerReportGeneratorResponse.wrap
      )
      .provide(r)
    def acceptGrant(request: AcceptGrantRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.AcceptGrantResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.AcceptGrantRequest,
      AcceptGrantResponse
    ]("acceptGrant", api.acceptGrant)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.licensemanager.model.AcceptGrantResponse.wrap)
      .provide(r)
    def updateLicenseSpecificationsForResource(
        request: UpdateLicenseSpecificationsForResourceRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseSpecificationsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest,
      UpdateLicenseSpecificationsForResourceResponse
    ](
      "updateLicenseSpecificationsForResource",
      api.updateLicenseSpecificationsForResource
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseSpecificationsForResourceResponse.wrap
      )
      .provide(r)
    def updateLicenseManagerReportGenerator(
        request: UpdateLicenseManagerReportGeneratorRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseManagerReportGeneratorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest,
      UpdateLicenseManagerReportGeneratorResponse
    ](
      "updateLicenseManagerReportGenerator",
      api.updateLicenseManagerReportGenerator
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseManagerReportGeneratorResponse.wrap
      )
      .provide(r)
    def deleteLicense(request: DeleteLicenseRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest,
        DeleteLicenseResponse
      ]("deleteLicense", api.deleteLicense)(request.buildAwsValue())
        .map(
          io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseResponse.wrap
        )
        .provide(r)
    def extendLicenseConsumption(request: ExtendLicenseConsumptionRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest,
      ExtendLicenseConsumptionResponse
    ]("extendLicenseConsumption", api.extendLicenseConsumption)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionResponse.wrap
    ).provide(r)
    def listLicenseConfigurations(
        request: ListLicenseConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfiguration.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsRequest,
      ListLicenseConfigurationsResponse,
      LicenseConfiguration
    ](
      "listLicenseConfigurations",
      api.listLicenseConfigurations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.licenseConfigurations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseConfiguration
          .wrap(item)
      )
      .provide(r)
    def listTokens(request: ListTokensRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.TokenData.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanager.model.ListTokensRequest,
      ListTokensResponse,
      TokenData
    ](
      "listTokens",
      api.listTokens,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.tokens().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.licensemanager.model.TokenData.wrap(item)
      )
      .provide(r)
    def listDistributedGrants(request: ListDistributedGrantsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsRequest,
      ListDistributedGrantsResponse,
      Grant
    ](
      "listDistributedGrants",
      api.listDistributedGrants,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.grants().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.licensemanager.model.Grant.wrap(item))
      .provide(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.ListTagsForResourceResponse.wrap
      )
      .provide(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.licensemanager.model.TagResourceResponse.wrap)
      .provide(r)
    def listLicenseVersions(request: ListLicenseVersionsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest,
      ListLicenseVersionsResponse,
      License
    ](
      "listLicenseVersions",
      api.listLicenseVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.licenses().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.licensemanager.model.License.wrap(item)
      )
      .provide(r)
    def getLicenseUsage(request: GetLicenseUsageRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.GetLicenseUsageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageRequest,
      GetLicenseUsageResponse
    ]("getLicenseUsage", api.getLicenseUsage)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.licensemanager.model.GetLicenseUsageResponse.wrap
      )
      .provide(r)
    def getLicense(request: GetLicenseRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.GetLicenseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest,
      GetLicenseResponse
    ]("getLicense", api.getLicense)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.licensemanager.model.GetLicenseResponse.wrap)
      .provide(r)
    def createLicenseConfiguration(
        request: CreateLicenseConfigurationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest,
      CreateLicenseConfigurationResponse
    ]("createLicenseConfiguration", api.createLicenseConfiguration)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationResponse.wrap
    ).provide(r)
    def listReceivedLicenses(request: ListReceivedLicensesRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.GrantedLicense.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesRequest,
      ListReceivedLicensesResponse,
      GrantedLicense
    ](
      "listReceivedLicenses",
      api.listReceivedLicenses,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.licenses().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.licensemanager.model.GrantedLicense.wrap(item)
      )
      .provide(r)
    def listReceivedGrants(request: ListReceivedGrantsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsRequest,
      ListReceivedGrantsResponse,
      Grant
    ](
      "listReceivedGrants",
      api.listReceivedGrants,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.grants().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.licensemanager.model.Grant.wrap(item))
      .provide(r)
    def listUsageForLicenseConfiguration(
        request: ListUsageForLicenseConfigurationRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest,
      ListUsageForLicenseConfigurationResponse,
      LicenseConfigurationUsage
    ](
      "listUsageForLicenseConfiguration",
      api.listUsageForLicenseConfiguration,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.licenseConfigurationUsageList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage
          .wrap(item)
      )
      .provide(r)
    def listFailuresForLicenseConfigurationOperations(
        request: ListFailuresForLicenseConfigurationOperationsRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsRequest,
      ListFailuresForLicenseConfigurationOperationsResponse,
      LicenseOperationFailure
    ](
      "listFailuresForLicenseConfigurationOperations",
      api.listFailuresForLicenseConfigurationOperations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.licenseOperationFailureList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure
          .wrap(item)
      )
      .provide(r)
    def getLicenseManagerReportGenerator(
        request: GetLicenseManagerReportGeneratorRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest,
      GetLicenseManagerReportGeneratorResponse
    ]("getLicenseManagerReportGenerator", api.getLicenseManagerReportGenerator)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorResponse.wrap
    ).provide(r)
  }
  def checkoutLicense(request: CheckoutLicenseRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.CheckoutLicenseResponse.ReadOnly
  ] = ZIO.accessM(_.get.checkoutLicense(request))
  def listLicenseManagerReportGenerators(
      request: ListLicenseManagerReportGeneratorsRequest
  ): ZStream[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.ReadOnly
  ] = ZStream.accessStream(_.get.listLicenseManagerReportGenerators(request))
  def getServiceSettings(request: GetServiceSettingsRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.GetServiceSettingsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getServiceSettings(request))
  def createToken(request: CreateTokenRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.CreateTokenResponse.ReadOnly
  ] = ZIO.accessM(_.get.createToken(request))
  def createLicense(request: CreateLicenseRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.CreateLicenseResponse.ReadOnly
  ] = ZIO.accessM(_.get.createLicense(request))
  def deleteLicenseConfiguration(
      request: DeleteLicenseConfigurationRequest
  ): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseConfigurationResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteLicenseConfiguration(request))
  def createGrant(request: CreateGrantRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.CreateGrantResponse.ReadOnly
  ] = ZIO.accessM(_.get.createGrant(request))
  def checkoutBorrowLicense(request: CheckoutBorrowLicenseRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.CheckoutBorrowLicenseResponse.ReadOnly
  ] = ZIO.accessM(_.get.checkoutBorrowLicense(request))
  def createGrantVersion(request: CreateGrantVersionRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionResponse.ReadOnly
  ] = ZIO.accessM(_.get.createGrantVersion(request))
  def getGrant(request: GetGrantRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.GetGrantResponse.ReadOnly
  ] = ZIO.accessM(_.get.getGrant(request))
  def getLicenseConversionTask(request: GetLicenseConversionTaskRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.GetLicenseConversionTaskResponse.ReadOnly
  ] = ZIO.accessM(_.get.getLicenseConversionTask(request))
  def deleteToken(request: DeleteTokenRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.DeleteTokenResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteToken(request))
  def listResourceInventory(request: ListResourceInventoryRequest): ZStream[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.ResourceInventory.ReadOnly
  ] = ZStream.accessStream(_.get.listResourceInventory(request))
  def getAccessToken(request: GetAccessTokenRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.GetAccessTokenResponse.ReadOnly
  ] = ZIO.accessM(_.get.getAccessToken(request))
  def listLicenses(request: ListLicensesRequest): ZStream[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly
  ] = ZStream.accessStream(_.get.listLicenses(request))
  def updateLicenseConfiguration(
      request: UpdateLicenseConfigurationRequest
  ): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseConfigurationResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateLicenseConfiguration(request))
  def createLicenseConversionTaskForResource(
      request: CreateLicenseConversionTaskForResourceRequest
  ): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConversionTaskForResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.createLicenseConversionTaskForResource(request))
  def createLicenseVersion(request: CreateLicenseVersionRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionResponse.ReadOnly
  ] = ZIO.accessM(_.get.createLicenseVersion(request))
  def createLicenseManagerReportGenerator(
      request: CreateLicenseManagerReportGeneratorRequest
  ): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.CreateLicenseManagerReportGeneratorResponse.ReadOnly
  ] = ZIO.accessM(_.get.createLicenseManagerReportGenerator(request))
  def listLicenseSpecificationsForResource(
      request: ListLicenseSpecificationsForResourceRequest
  ): ZStream[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.LicenseSpecification.ReadOnly
  ] = ZStream.accessStream(_.get.listLicenseSpecificationsForResource(request))
  def deleteGrant(request: DeleteGrantRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.DeleteGrantResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteGrant(request))
  def listLicenseConversionTasks(
      request: ListLicenseConversionTasksRequest
  ): ZStream[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.LicenseConversionTask.ReadOnly
  ] = ZStream.accessStream(_.get.listLicenseConversionTasks(request))
  def rejectGrant(request: RejectGrantRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.RejectGrantResponse.ReadOnly
  ] = ZIO.accessM(_.get.rejectGrant(request))
  def checkInLicense(request: CheckInLicenseRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.CheckInLicenseResponse.ReadOnly
  ] = ZIO.accessM(_.get.checkInLicense(request))
  def updateServiceSettings(request: UpdateServiceSettingsRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.UpdateServiceSettingsResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateServiceSettings(request))
  def getLicenseConfiguration(request: GetLicenseConfigurationRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.GetLicenseConfigurationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getLicenseConfiguration(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.UntagResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.untagResource(request))
  def listAssociationsForLicenseConfiguration(
      request: ListAssociationsForLicenseConfigurationRequest
  ): ZStream[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationAssociation.ReadOnly
  ] =
    ZStream.accessStream(_.get.listAssociationsForLicenseConfiguration(request))
  def deleteLicenseManagerReportGenerator(
      request: DeleteLicenseManagerReportGeneratorRequest
  ): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.DeleteLicenseManagerReportGeneratorResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteLicenseManagerReportGenerator(request))
  def acceptGrant(request: AcceptGrantRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.AcceptGrantResponse.ReadOnly
  ] = ZIO.accessM(_.get.acceptGrant(request))
  def updateLicenseSpecificationsForResource(
      request: UpdateLicenseSpecificationsForResourceRequest
  ): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseSpecificationsForResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateLicenseSpecificationsForResource(request))
  def updateLicenseManagerReportGenerator(
      request: UpdateLicenseManagerReportGeneratorRequest
  ): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.UpdateLicenseManagerReportGeneratorResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateLicenseManagerReportGenerator(request))
  def deleteLicense(
      request: DeleteLicenseRequest
  ): ZIO[LicenseManager, AwsError, ReadOnly] =
    ZIO.accessM(_.get.deleteLicense(request))
  def extendLicenseConsumption(request: ExtendLicenseConsumptionRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.ExtendLicenseConsumptionResponse.ReadOnly
  ] = ZIO.accessM(_.get.extendLicenseConsumption(request))
  def listLicenseConfigurations(
      request: ListLicenseConfigurationsRequest
  ): ZStream[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.LicenseConfiguration.ReadOnly
  ] = ZStream.accessStream(_.get.listLicenseConfigurations(request))
  def listTokens(request: ListTokensRequest): ZStream[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.TokenData.ReadOnly
  ] = ZStream.accessStream(_.get.listTokens(request))
  def listDistributedGrants(request: ListDistributedGrantsRequest): ZStream[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly
  ] = ZStream.accessStream(_.get.listDistributedGrants(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.TagResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.tagResource(request))
  def listLicenseVersions(request: ListLicenseVersionsRequest): ZStream[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.License.ReadOnly
  ] = ZStream.accessStream(_.get.listLicenseVersions(request))
  def getLicenseUsage(request: GetLicenseUsageRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.GetLicenseUsageResponse.ReadOnly
  ] = ZIO.accessM(_.get.getLicenseUsage(request))
  def getLicense(request: GetLicenseRequest): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.GetLicenseResponse.ReadOnly
  ] = ZIO.accessM(_.get.getLicense(request))
  def createLicenseConfiguration(
      request: CreateLicenseConfigurationRequest
  ): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationResponse.ReadOnly
  ] = ZIO.accessM(_.get.createLicenseConfiguration(request))
  def listReceivedLicenses(request: ListReceivedLicensesRequest): ZStream[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.GrantedLicense.ReadOnly
  ] = ZStream.accessStream(_.get.listReceivedLicenses(request))
  def listReceivedGrants(request: ListReceivedGrantsRequest): ZStream[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.Grant.ReadOnly
  ] = ZStream.accessStream(_.get.listReceivedGrants(request))
  def listUsageForLicenseConfiguration(
      request: ListUsageForLicenseConfigurationRequest
  ): ZStream[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.LicenseConfigurationUsage.ReadOnly
  ] = ZStream.accessStream(_.get.listUsageForLicenseConfiguration(request))
  def listFailuresForLicenseConfigurationOperations(
      request: ListFailuresForLicenseConfigurationOperationsRequest
  ): ZStream[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.LicenseOperationFailure.ReadOnly
  ] = ZStream.accessStream(
    _.get.listFailuresForLicenseConfigurationOperations(request)
  )
  def getLicenseManagerReportGenerator(
      request: GetLicenseManagerReportGeneratorRequest
  ): ZIO[
    LicenseManager,
    AwsError,
    io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorResponse.ReadOnly
  ] = ZIO.accessM(_.get.getLicenseManagerReportGenerator(request))
}
